/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.gui.glossary.TransTips;
import org.omegat.util.Preferences;

public class TransTipsPopup
implements IPopupMenuConstructor {
    @Override
    public void addItems(final JPopupMenu menu, JTextComponent comp, final int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
        if (!Preferences.isPreference("transtips")) {
            return;
        }
        if (!isInActiveEntry || isInActiveTranslation) {
            return;
        }
        final int startSource = sb.getStartSourcePosition();
        int len = sb.getSourceText().length();
        if (mousepos < startSource || mousepos > startSource + len) {
            return;
        }
        TransTips.Search callback = new TransTips.Search(){

            @Override
            public void found(GlossaryEntry ge, int start, int end) {
                if (startSource + start <= mousepos && mousepos <= startSource + end) {
                    String[] arr$ = ge.getLocTerms(true);
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String s;
                        final String txt = s = arr$[i$];
                        JMenuItem it = menu.add(txt);
                        it.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Core.getEditor().insertText(txt);
                            }
                        });
                    }
                }
            }
        };
        for (GlossaryEntry ge : GlossaryTextArea.nowEntries) {
            TransTips.search(sb.getSourceText(), ge, callback);
        }
        menu.addSeparator();
    }
}

