/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Cursor;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.KnownException;
import org.omegat.core.data.ProjectFactory;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.team.GITRemoteRepository;
import org.omegat.core.team.IRemoteRepository;
import org.omegat.core.team.RepositoryUtils;
import org.omegat.core.team.SVNRemoteRepository;
import org.omegat.gui.dialogs.NewProjectFileChooser;
import org.omegat.gui.dialogs.NewTeamProject;
import org.omegat.gui.dialogs.ProjectPropertiesDialog;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.RecentProjects;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.OpenProjectFileChooser;
import org.omegat.util.gui.UIThreadsUtil;

public class ProjectUICommands {
    public static void projectCreate() {
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            return;
        }
        NewProjectFileChooser ndc = new NewProjectFileChooser();
        int ndcResult = ndc.showSaveDialog(Core.getMainWindow().getApplicationFrame());
        if (ndcResult != 0) {
            return;
        }
        final File dir = ndc.getSelectedFile();
        new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                dir.mkdirs();
                ProjectPropertiesDialog newProjDialog = new ProjectPropertiesDialog(new ProjectProperties(dir), dir.getAbsolutePath(), ProjectPropertiesDialog.Mode.NEW_PROJECT);
                newProjDialog.setVisible(true);
                newProjDialog.dispose();
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = new Cursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                ProjectProperties newProps = newProjDialog.getResult();
                if (newProps == null) {
                    dir.delete();
                    mainWindow.setCursor(oldCursor);
                    return null;
                }
                String projectRoot = newProps.getProjectRoot();
                if (!StringUtil.isEmpty(projectRoot)) {
                    try {
                        ProjectFactory.createProject(newProps);
                        Core.getProject().saveProjectProperties();
                    }
                    catch (Exception ex) {
                        Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                        Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    }
                }
                RecentProjects.add(dir.getAbsolutePath());
                mainWindow.setCursor(oldCursor);
                return null;
            }
        }.execute();
    }

    public static void projectTeamCreate() {
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            return;
        }
        new SwingWorker<Object, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object doInBackground() throws Exception {
                IRemoteRepository repository;
                Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
                final NewTeamProject dialog = new NewTeamProject(Core.getMainWindow().getApplicationFrame());
                dialog.setVisible(true);
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = new Cursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                File localDirectory = new File(dialog.txtDirectory.getText());
                try {
                    if (!dialog.ok) {
                        Core.getMainWindow().showStatusMessageRB("TEAM_CANCELLED", new Object[0]);
                        mainWindow.setCursor(oldCursor);
                        Object var7_6 = null;
                        return var7_6;
                    }
                    if (dialog.repoType == null) {
                        mainWindow.setCursor(oldCursor);
                        Object var7_7 = null;
                        return var7_7;
                    }
                    repository = dialog.repoType.getConstructor(File.class).newInstance(localDirectory);
                    repository.setCredentials(dialog.credentials);
                    new RepositoryUtils.AskCredentials(){

                        @Override
                        public void callRepository() throws Exception {
                            Core.getMainWindow().showStatusMessageRB("TEAM_CHECKOUT", new Object[0]);
                            repository.checkoutFullProject(dialog.txtRepositoryURL.getText());
                            Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
                        }
                    }.execute(repository);
                }
                catch (IRemoteRepository.BadRepositoryException bre) {
                    Core.getMainWindow().showErrorDialogRB("TF_ERROR", "TEAM_BADREPOSITORY_ERROR", bre.getMessage());
                    mainWindow.setCursor(oldCursor);
                    Object var8_13 = null;
                    return var8_13;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Core.getMainWindow().displayErrorRB(ex, "TEAM_CHECKOUT_ERROR", new Object[0]);
                    mainWindow.setCursor(oldCursor);
                    Object var8_14 = null;
                    return var8_14;
                }
                finally {
                    if (dialog.credentials != null) {
                        dialog.credentials.clear();
                    }
                }
                try {
                    File[] projectFolders;
                    ProjectProperties props = ProjectFileStorage.loadProjectProperties(localDirectory);
                    for (File f : projectFolders = new File[]{new File(props.getGlossaryRoot()), new File(props.getTMRoot()), new File(props.getTMAutoRoot()), new File(props.getDictRoot()), new File(props.getTargetRoot())}) {
                        try {
                            if (f.exists()) continue;
                            f.mkdir();
                        }
                        catch (Exception e) {
                            Log.logErrorRB(e, "TEAM_MISSING_FOLDER", f.getName());
                        }
                    }
                    ProjectFactory.loadProject(props, repository, true);
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
                RecentProjects.add(localDirectory.getAbsolutePath());
                mainWindow.setCursor(oldCursor);
                return null;
            }
        }.execute();
    }

    public static void projectOpen(File projectDirectory) {
        ProjectUICommands.projectOpen(projectDirectory, false);
    }

    public static void projectOpen(final File projectDirectory, boolean closeCurrent) {
        File projectRootFolder;
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            if (closeCurrent) {
                CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

                    @Override
                    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                        if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                            ProjectUICommands.projectOpen(projectDirectory, false);
                            CoreEvents.unregisterProjectChangeListener(this);
                        }
                    }
                });
                ProjectUICommands.projectClose();
            }
            return;
        }
        if (projectDirectory == null) {
            OpenProjectFileChooser pfc = new OpenProjectFileChooser();
            if (0 != pfc.showOpenDialog(Core.getMainWindow().getApplicationFrame())) {
                return;
            }
            projectRootFolder = pfc.getSelectedFile();
        } else {
            projectRootFolder = projectDirectory;
        }
        new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                IRemoteRepository repository;
                ProjectProperties props;
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = new Cursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                try {
                    props = ProjectFileStorage.loadProjectProperties(projectRootFolder);
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    mainWindow.setCursor(oldCursor);
                    return null;
                }
                try {
                    repository = Core.getParams().containsKey("no-team") ? null : (SVNRemoteRepository.isSVNDirectory(projectRootFolder) ? new SVNRemoteRepository(projectRootFolder) : (GITRemoteRepository.isGITDirectory(projectRootFolder) ? new GITRemoteRepository(projectRootFolder) : null));
                }
                catch (Exception e) {
                    return null;
                }
                if (repository != null) {
                    boolean onlineMode = true;
                    try {
                        File tmxFile = new File(props.getProjectInternal() + "project_save.tmx");
                        File GlossaryFile = new File(props.getWriteableGlossary());
                        if (repository.isChanged(tmxFile) || repository.isChanged(GlossaryFile)) {
                            Log.logWarningRB("TEAM_NOCHECKOUT", new Object[0]);
                            Core.getMainWindow().showErrorDialogRB("TEAM_NOCHECKOUT_TITLE", "TEAM_NOCHECKOUT", new Object[0]);
                        } else {
                            new RepositoryUtils.AskCredentials(){

                                @Override
                                public void callRepository() throws Exception {
                                    Core.getMainWindow().showStatusMessageRB("TEAM_SYNCHRONIZE", new Object[0]);
                                    repository.updateFullProject();
                                    Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
                                }
                            }.execute(repository);
                        }
                    }
                    catch (IRemoteRepository.NetworkException ex) {
                        onlineMode = false;
                        Log.logInfoRB("VCS_OFFLINE", new Object[0]);
                        Core.getMainWindow().displayWarningRB("VCS_OFFLINE", new Object[0]);
                    }
                    catch (Exception ex) {
                        Log.logErrorRB(ex, "TEAM_CHECKOUT_ERROR", ex.getMessage());
                        Core.getMainWindow().displayErrorRB(ex, "TEAM_CHECKOUT_ERROR", ex.getMessage());
                        mainWindow.setCursor(oldCursor);
                        return null;
                    }
                    try {
                        ProjectFactory.loadProject(props, repository, onlineMode);
                    }
                    catch (Exception ex) {
                        Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                        Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                        mainWindow.setCursor(oldCursor);
                        return null;
                    }
                }
                try {
                    boolean needToSaveProperties = false;
                    while (!props.isProjectValid()) {
                        needToSaveProperties = true;
                        ProjectPropertiesDialog prj = new ProjectPropertiesDialog(props, new File(projectRootFolder, "omegat.project").getAbsolutePath(), ProjectPropertiesDialog.Mode.RESOLVE_DIRS);
                        prj.setVisible(true);
                        props = prj.getResult();
                        prj.dispose();
                        if (props != null) continue;
                        mainWindow.setCursor(oldCursor);
                        return null;
                    }
                    ProjectFactory.loadProject(props, repository, true);
                    if (needToSaveProperties) {
                        Core.getProject().saveProjectProperties();
                    }
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    mainWindow.setCursor(oldCursor);
                    return null;
                }
                RecentProjects.add(projectRootFolder.getAbsolutePath());
                mainWindow.setCursor(oldCursor);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Core.getEditor().requestFocus();
                        }
                    });
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public static void projectReload() {
        ProjectUICommands.performProjectMenuItemPreConditions();
        final ProjectProperties props = Core.getProject().getProjectProperties();
        new SwingWorker<Object, Void>(){
            int previousCurEntryNum = Core.getEditor().getCurrentEntryNumber();

            @Override
            protected Object doInBackground() throws Exception {
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = new Cursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                final IRemoteRepository repository = Core.getProject().getRepository();
                Core.getProject().saveProject();
                ProjectFactory.closeProject();
                if (repository != null) {
                    new RepositoryUtils.AskCredentials(){

                        @Override
                        public void callRepository() throws Exception {
                            Core.getMainWindow().showStatusMessageRB("TEAM_SYNCHRONIZE", new Object[0]);
                            repository.updateFullProject();
                            Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
                        }
                    }.execute(repository);
                }
                ProjectFactory.loadProject(props, repository, true);
                mainWindow.setCursor(oldCursor);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Core.getEditor().gotoEntry(previousCurEntryNum);
                            Core.getEditor().requestFocus();
                        }
                    });
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE");
                }
            }
        }.execute();
    }

    public static void projectSave() {
        ProjectUICommands.performProjectMenuItemPreConditions();
        new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = new Cursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                mainWindow.showStatusMessageRB("MW_STATUS_SAVING", new Object[0]);
                Core.getProject().saveProject();
                mainWindow.showStatusMessageRB("MW_STATUS_SAVED", new Object[0]);
                mainWindow.setCursor(oldCursor);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE");
                }
            }
        }.execute();
    }

    public static void projectClose() {
        ProjectUICommands.performProjectMenuItemPreConditions();
        new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                Core.getMainWindow().showStatusMessageRB("MW_STATUS_SAVING", new Object[0]);
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = new Cursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                Preferences.save();
                Core.getProject().saveProject();
                Core.getMainWindow().showStatusMessageRB("MW_STATUS_SAVED", new Object[0]);
                mainWindow.setCursor(oldCursor);
                Core.getMainWindow().showLengthMessage(OStrings.getString("MW_SEGMENT_LENGTH_DEFAULT"));
                Core.getMainWindow().showProgressMessage(Preferences.getPreferenceEnumDefault("sb_progress_mode", MainWindowUI.STATUS_BAR_MODE.DEFAULT) == MainWindowUI.STATUS_BAR_MODE.DEFAULT ? OStrings.getString("MW_PROGRESS_DEFAULT") : OStrings.getProgressBarDefaultPrecentageText());
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    ProjectFactory.closeProject();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE");
                }
            }
        }.execute();
    }

    public static void projectEditProperties() {
        ProjectUICommands.performProjectMenuItemPreConditions();
        ProjectPropertiesDialog prj = new ProjectPropertiesDialog(Core.getProject().getProjectProperties(), Core.getProject().getProjectProperties().getProjectName(), Core.getProject().getRepository() == null ? ProjectPropertiesDialog.Mode.EDIT_PROJECT : ProjectPropertiesDialog.Mode.EDIT_TEAM_PROJECT);
        prj.setVisible(true);
        final ProjectProperties newProps = prj.getResult();
        prj.dispose();
        if (newProps == null) {
            return;
        }
        int res = JOptionPane.showConfirmDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0);
        if (res != 0) {
            return;
        }
        new SwingWorker<Object, Void>(){
            int previousCurEntryNum = Core.getEditor().getCurrentEntryNumber();

            @Override
            protected Object doInBackground() throws Exception {
                Core.getProject().saveProject();
                IRemoteRepository repo = Core.getProject().getRepository();
                ProjectFactory.closeProject();
                ProjectFactory.loadProject(newProps, repo, true);
                Core.getProject().saveProjectProperties();
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Core.getEditor().gotoEntry(previousCurEntryNum);
                            Core.getEditor().requestFocus();
                        }
                    });
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE");
                }
            }
        }.execute();
    }

    public static void projectCompile() {
        ProjectUICommands.performProjectMenuItemPreConditions();
        new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                Core.getProject().saveProject(false);
                Core.getProject().compileProject(".*");
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "TF_COMPILE_ERROR");
                }
            }
        }.execute();
    }

    public static void projectSingleCompile(final String sourcePattern) {
        ProjectUICommands.performProjectMenuItemPreConditions();
        new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                Core.getProject().saveProject(false);
                Core.getProject().compileProject(sourcePattern);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "TF_COMPILE_ERROR");
                }
            }
        }.execute();
    }

    private static void performProjectMenuItemPreConditions() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
    }

    private static void processSwingWorkerException(Exception ex, String errorCode) {
        if (ex instanceof ExecutionException) {
            Log.logErrorRB(ex.getCause(), errorCode, new Object[0]);
            if (ex.getCause() instanceof KnownException) {
                KnownException e = (KnownException)ex.getCause();
                Core.getMainWindow().displayErrorRB(e.getCause(), e.getMessage(), e.getParams());
            } else {
                Core.getMainWindow().displayErrorRB(ex.getCause(), errorCode, new Object[0]);
            }
        } else {
            Log.logErrorRB(ex, errorCode, new Object[0]);
            Core.getMainWindow().displayErrorRB(ex, errorCode, new Object[0]);
        }
    }
}

