/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.util.ArrayList;
import java.util.List;
import org.omegat.util.Preferences;

public class HistoryManager {
    private static final List<String> searchItems;
    private static final List<String> replaceItems;
    private static final int maxItems;

    private HistoryManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchItem(String item) {
        List<String> list = searchItems;
        synchronized (list) {
            searchItems.remove(item);
            searchItems.add(0, item);
            while (searchItems.size() > maxItems) {
                searchItems.remove(maxItems);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addReplaceItem(String item) {
        List<String> list = replaceItems;
        synchronized (list) {
            replaceItems.remove(item);
            replaceItems.add(0, item);
            while (replaceItems.size() > maxItems) {
                replaceItems.remove(maxItems);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSearchItems() {
        List<String> list = searchItems;
        synchronized (list) {
            return searchItems.toArray(new String[searchItems.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getReplaceItems() {
        List<String> list = replaceItems;
        synchronized (list) {
            return replaceItems.toArray(new String[replaceItems.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        int i;
        List<String> list = searchItems;
        synchronized (list) {
            for (i = 0; i < searchItems.size(); ++i) {
                Preferences.setPreference("search_window_search_history_item_" + i, searchItems.get(i));
            }
        }
        list = replaceItems;
        synchronized (list) {
            for (i = 0; i < replaceItems.size(); ++i) {
                Preferences.setPreference("search_window_replace_history_item_" + i, replaceItems.get(i));
            }
        }
    }

    static {
        maxItems = Preferences.getPreferenceDefault("search_window_history_size", 10);
        searchItems = new ArrayList<String>(maxItems);
        replaceItems = new ArrayList<String>(maxItems);
        for (int i = 0; i < maxItems; ++i) {
            String replaceItem;
            String searchItem = Preferences.getPreferenceDefault("search_window_search_history_item_" + i, null);
            if (searchItem != null) {
                searchItems.add(searchItem);
            }
            if ((replaceItem = Preferences.getPreferenceDefault("search_window_replace_history_item_" + i, null)) == null) continue;
            replaceItems.add(replaceItem);
        }
    }
}

