/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.StringContent;
import javax.swing.undo.UndoManager;

public class MFindField
extends JTextField
implements FocusListener {
    private UndoManager undoManager;
    private Font normalFont;
    private Font defaultTextFont;
    private Color normalColor;
    private String defaultText;
    private boolean isDirty;
    ActionListener enterActionListener;

    public MFindField() {
        KeyStroke undo = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
        AbstractAction undoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MFindField.this.undo();
            }
        };
        this.getInputMap().put(undo, "UNDO");
        this.getActionMap().put("UNDO", undoAction);
        KeyStroke redo = KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
        AbstractAction redoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MFindField.this.redo();
            }
        };
        this.getInputMap().put(redo, "REDO");
        this.getActionMap().put("REDO", redoAction);
        this.defaultText = null;
        this.normalFont = this.getFont();
        this.defaultTextFont = this.normalFont.deriveFont(2);
        this.normalColor = this.getForeground();
        this.isDirty = false;
        this.addFocusListener(this);
    }

    public void setDefaultText(String text) {
        this.defaultText = text;
        if (this.getText().isEmpty()) {
            this.showDefaultText();
        }
    }

    private void showDefaultText() {
        this.setText(this.defaultText);
        this.setFont(this.defaultTextFont);
        this.setForeground(this.getDisabledTextColor());
        this.isDirty = false;
    }

    @Override
    protected Document createDefaultModel() {
        PlainDocument doc = new PlainDocument(new StringContent());
        this.undoManager = new UndoManager();
        doc.addUndoableEditListener(this.undoManager);
        return doc;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (this.enterActionListener != null && e.getKeyCode() == 10 && e.getID() == 401 && !this.getText().equals("")) {
            this.enterActionListener.actionPerformed(null);
        } else {
            super.processKeyEvent(e);
        }
        if (e.getID() == 400) {
            this.isDirty = true;
        }
    }

    protected void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    protected void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.defaultText != null && this.isEditable() && this.getText().isEmpty()) {
            this.setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.defaultText != null && this.isEditable() && this.getText().isEmpty()) {
            this.showDefaultText();
        }
    }

    @Override
    public String getText() {
        String content = super.getText();
        if (!this.isDirty && this.defaultText != null && content.equals(this.defaultText)) {
            return "";
        }
        return content;
    }

    @Override
    public void setText(String t) {
        this.setFont(this.normalFont);
        this.setForeground(this.normalColor);
        if (!t.isEmpty()) {
            this.isDirty = true;
        }
        super.setText(t);
    }
}

