/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omegat.gui.help.HelpFrame;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;

public class FileUtil {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    public static long RENAME_RETRY_TIMEOUT = 3000L;
    private static int TEMP_DIR_ATTEMPTS = 10000;

    public static void removeOldBackups(final File originalFile, int maxBackups) {
        try {
            File[] bakFiles = originalFile.getParentFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return !f.isDirectory() && f.getName().startsWith(originalFile.getName()) && f.getName().endsWith(".bak");
                }
            });
            if (bakFiles != null && bakFiles.length > maxBackups) {
                Arrays.sort(bakFiles, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        if (f2.lastModified() < f1.lastModified()) {
                            return -1;
                        }
                        if (f2.lastModified() > f1.lastModified()) {
                            return 1;
                        }
                        return 0;
                    }
                });
                for (int i = maxBackups; i < bakFiles.length; ++i) {
                    bakFiles[i].delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void backupFile(File f) throws IOException {
        long fileMillis = f.lastModified();
        String str = new SimpleDateFormat("yyyyMMddHHmm").format(new Date(fileMillis));
        LFileCopy.copy(f, new File(f.getPath() + "." + str + ".bak"));
    }

    public static void rename(File from, File to) throws IOException {
        if (!from.exists()) {
            throw new IOException("Source file to rename (" + from + ") doesn't exist");
        }
        if (to.exists()) {
            throw new IOException("Target file to rename (" + to + ") already exists");
        }
        long b = System.currentTimeMillis();
        while (!from.renameTo(to)) {
            long e = System.currentTimeMillis();
            if (e - b <= RENAME_RETRY_TIMEOUT) continue;
            throw new IOException("Error renaming " + from + " to " + to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeScriptFile(String textToWrite, String fileName) {
        File outFile = new File(StaticUtils.getScriptDir(), fileName);
        File outFileTemp = new File(StaticUtils.getScriptDir(), fileName + ".temp");
        outFile.delete();
        BufferedWriter bw = null;
        try {
            textToWrite = textToWrite.replaceAll("\n", System.getProperty("line.separator"));
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFileTemp), "UTF-8"));
            bw.write(textToWrite);
        }
        catch (Exception ex) {
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        outFileTemp.renameTo(outFile);
        return outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readScriptFile(File file) {
        String string;
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            StringWriter out = new StringWriter();
            LFileCopy.copy(rd, out);
            string = out.toString().replace(System.getProperty("line.separator"), "\n");
        }
        catch (Throwable throwable) {
            try {
                rd.close();
                throw throwable;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        rd.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) throws IOException {
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            StringWriter out = new StringWriter();
            LFileCopy.copy(rd, out);
            String string = out.toString();
            return string;
        }
        finally {
            rd.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(File file, String text) throws IOException {
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            wr.write(text);
        }
        finally {
            ((Writer)wr).close();
        }
    }

    public static List<File> findFiles(File dir, FileFilter filter) {
        ArrayList<File> result = new ArrayList<File>();
        HashSet<String> knownDirs = new HashSet<String>();
        FileUtil.findFiles(dir, filter, result, knownDirs);
        return result;
    }

    private static void findFiles(File dir, FileFilter filter, List<File> result, Set<String> knownDirs) {
        try {
            String curr_dir = dir.getCanonicalPath();
            if (!knownDirs.add(curr_dir)) {
                return;
            }
        }
        catch (IOException ex) {
            Log.log(ex);
            return;
        }
        File[] list = dir.listFiles();
        if (list != null) {
            for (File f : list) {
                if (f.isDirectory()) {
                    FileUtil.findFiles(f, filter, result, knownDirs);
                    continue;
                }
                if (!filter.accept(f)) continue;
                result.add(f);
            }
        }
    }

    public static String computeRelativePath(File rootDir, File file) throws IOException {
        String rootAbs = rootDir.getAbsolutePath().replace('\\', '/') + '/';
        String fileAbs = file.getAbsolutePath().replace('\\', '/');
        switch (Platform.getOsType()) {
            case WIN32: 
            case WIN64: {
                if (fileAbs.toUpperCase().startsWith(rootAbs.toUpperCase())) break;
                throw new IOException("File '" + file + "' is not under dir '" + rootDir + "'");
            }
            default: {
                if (fileAbs.startsWith(rootAbs)) break;
                throw new IOException("File '" + file + "' is not under dir '" + rootDir + "'");
            }
        }
        return fileAbs.substring(rootAbs.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadTextFileFromDoc(String textFile) {
        String string;
        URL url = HelpFrame.getHelpFileURL(null, textFile);
        if (url == null) {
            return HelpFrame.errorHaiku();
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
        try {
            StringWriter out = new StringWriter();
            LFileCopy.copy(rd, out);
            string = out.toString();
        }
        catch (Throwable throwable) {
            try {
                rd.close();
                throw throwable;
            }
            catch (IOException ex) {
                return HelpFrame.errorHaiku();
            }
        }
        rd.close();
        return string;
    }

    public static boolean deleteTree(File dir) {
        if (!dir.exists()) {
            return false;
        }
        if (dir.delete()) {
            return true;
        }
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File file : contents) {
                FileUtil.deleteTree(file);
            }
        }
        return dir.delete();
    }

    public static void copyFilesTo(File destination, File[] toCopy, ICollisionCallback onCollision) throws IOException {
        if (destination.exists() && !destination.isDirectory()) {
            throw new IOException("Copy-to destination exists and is not a directory.");
        }
        Map<File, File> collisions = FileUtil.copyFilesTo(destination, toCopy, (File)null);
        if (collisions.isEmpty()) {
            return;
        }
        ArrayList<File> toReplace = new ArrayList<File>();
        ArrayList<File> toDelete = new ArrayList<File>();
        int count = 0;
        for (Map.Entry<File, File> e : collisions.entrySet()) {
            if (onCollision != null && onCollision.isCanceled()) break;
            if (onCollision == null || onCollision.shouldReplace(e.getValue(), count, collisions.size())) {
                toReplace.add(e.getKey());
                toDelete.add(e.getValue());
            }
            ++count;
        }
        if (onCollision == null || !onCollision.isCanceled()) {
            for (File file : toDelete) {
                FileUtil.deleteTree(file);
            }
            FileUtil.copyFilesTo(destination, toReplace.toArray(new File[toReplace.size()]), (File)null);
        }
    }

    private static Map<File, File> copyFilesTo(File destination, File[] toCopy, File root) throws IOException {
        LinkedHashMap<File, File> collisions = new LinkedHashMap<File, File>();
        for (File file : toCopy) {
            if (destination.getPath().startsWith(file.getPath())) continue;
            File thisRoot = root == null ? file.getParentFile() : root;
            String filePath = file.getPath();
            String relPath = filePath.substring(thisRoot.getPath().length(), filePath.length());
            File dest = new File(destination, relPath);
            if (file.equals(dest)) continue;
            if (dest.exists()) {
                collisions.put(file, dest);
                continue;
            }
            if (file.isDirectory()) {
                FileUtil.copyFilesTo(destination, file.listFiles(), thisRoot);
                continue;
            }
            LFileCopy.copy(file, dest);
        }
        return collisions;
    }

    public static File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < TEMP_DIR_ATTEMPTS; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within " + TEMP_DIR_ATTEMPTS + " attempts (tried " + baseName + "0 to " + baseName + (TEMP_DIR_ATTEMPTS - 1) + ')');
    }

    public static interface ICollisionCallback {
        public boolean isCanceled();

        public boolean shouldReplace(File var1, int var2, int var3);
    }
}

