/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omegat.core.segmentation.SRX;
import org.omegat.filters2.TranslationException;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.xml.XMLBlock;
import org.omegat.util.xml.XMLStreamReader;

public class Preferences {
    public static final String FILE_PREFERENCES = "omegat" + OStrings.getBrandingToken() + ".prefs";
    public static final String SOURCE_LOCALE = "source_lang";
    public static final String TARGET_LOCALE = "target_lang";
    public static final String CURRENT_FOLDER = "current_folder";
    public static final String SOURCE_FOLDER = "source_folder";
    public static final String TARGET_FOLDER = "target_folder";
    public static final String TM_FOLDER = "tm_folder";
    public static final String DICT_FOLDER = "dict_folder";
    public static final String GLOSSARY_FOLDER = "glossary_folder";
    public static final String GLOSSARY_FILE = "glossary_file";
    public static final String MT_AUTO_FETCH = "mt_auto_fetch";
    public static final String MT_ONLY_UNTRANSLATED = "mt_only_untranslated";
    public static final String GLOSSARY_TBX_DISPLAY_CONTEXT = "glossary_tbx_display_context";
    public static final String GLOSSARY_NOT_EXACT_MATCH = "glossary_not_exact_match";
    public static final String GLOSSARY_STEMMING = "glossary_stemming";
    public static final String GLOSSARY_REPLACE_ON_INSERT = "glossary_replace_on_insert";
    public static final String DICTIONARY_FUZZY_MATCHING = "dictionary_fuzzy_matching";
    public static final String MAINWINDOW_WIDTH = "screen_width";
    public static final String MAINWINDOW_HEIGHT = "screen_height";
    public static final String MAINWINDOW_X = "screen_x";
    public static final String MAINWINDOW_Y = "screen_y";
    public static final String MAINWINDOW_LAYOUT = "docking_layout";
    public static final String PROJECT_FILES_WINDOW_WIDTH = "project_files_window_width";
    public static final String PROJECT_FILES_WINDOW_HEIGHT = "project_files_window_height";
    public static final String PROJECT_FILES_WINDOW_X = "project_files_window_x";
    public static final String PROJECT_FILES_WINDOW_Y = "project_files_window_y";
    public static final String PROJECT_FILES_USE_FONT = "project_files_use_font";
    public static final String PROJECT_FILES_SHOW_ON_LOAD = "project_files_show_on_load";
    public static final String SEARCHWINDOW_WIDTH = "search_window_width";
    public static final String SEARCHWINDOW_HEIGHT = "search_window_height";
    public static final String SEARCHWINDOW_X = "search_window_x";
    public static final String SEARCHWINDOW_Y = "search_window_y";
    public static final String SEARCHWINDOW_SEARCH_TYPE = "search_window_search_type";
    public static final String SEARCHWINDOW_REPLACE_TYPE = "search_window_replace_type";
    public static final String SEARCHWINDOW_CASE_SENSITIVE = "search_window_case_sensitive";
    public static final String SEARCHWINDOW_SPACE_MATCH_NBSP = "search_window_space_match_nbsp";
    public static final String SEARCHWINDOW_CASE_SENSITIVE_REPLACE = "search_window_case_sensitive_replace";
    public static final String SEARCHWINDOW_SPACE_MATCH_NBSP_REPLACE = "search_window_space_match_nbsp_replace";
    public static final String SEARCHWINDOW_REPLACE_UNTRANSLATED = "search_window_replace_untranslated";
    public static final String SEARCHWINDOW_SEARCH_SOURCE = "search_window_search_source";
    public static final String SEARCHWINDOW_SEARCH_TRANSLATION = "search_window_search_translation";
    public static final String SEARCHWINDOW_SEARCH_STATE = "search_window_search_state";
    public static final String SEARCHWINDOW_SEARCH_NOTES = "search_window_search_notes";
    public static final String SEARCHWINDOW_SEARCH_COMMENTS = "search_window_search_comments";
    public static final String SEARCHWINDOW_REG_EXPRESSIONS = "search_window_reg_expressions";
    public static final String SEARCHWINDOW_GLOSSARY_SEARCH = "search_window_glossary_search";
    public static final String SEARCHWINDOW_MEMORY_SEARCH = "search_window_memory_search";
    public static final String SEARCHWINDOW_TM_SEARCH = "search_window_tm_search";
    public static final String SEARCHWINDOW_ALL_RESULTS = "search_window_all_results";
    public static final String SEARCHWINDOW_FILE_NAMES = "search_window_file_names";
    public static final String SEARCHWINDOW_ADVANCED_VISIBLE = "search_window_advanced_visible";
    public static final String SEARCHWINDOW_SEARCH_AUTHOR = "search_window_search_author";
    public static final String SEARCHWINDOW_AUTHOR_NAME = "search_window_author_name";
    public static final String SEARCHWINDOW_DATE_FROM = "search_window_date_from";
    public static final String SEARCHWINDOW_DATE_FROM_VALUE = "search_window_date_from_value";
    public static final String SEARCHWINDOW_DATE_TO = "search_window_date_to";
    public static final String SEARCHWINDOW_DATE_TO_VALUE = "search_window_date_to_value";
    public static final String SEARCHWINDOW_NUMBER_OF_RESULTS = "search_window_number_of_results";
    public static final String SEARCHWINDOW_DIR = "search_window_dir";
    public static final String SEARCHWINDOW_SEARCH_FILES = "search_window_search_files";
    public static final String SEARCHWINDOW_RECURSIVE = "search_window_search_recursive";
    public static final String SEARCHWINDOW_AUTO_SYNC = "search_window_auto_sync";
    public static final String SEARCHWINDOW_BACK_TO_INITIAL_SEGMENT = "search_window_back_to_initial_segment";
    public static final String SEARCHWINDOW_EXCLUDE_ORPHANS = "search_window_exclude_orphans";
    public static final String SEARCHWINDOW_HISTORY_SIZE = "search_window_history_size";
    public static final String SEARCHWINDOW_SEARCH_HISTORY_ITEM_PREFIX = "search_window_search_history_item_";
    public static final String SEARCHWINDOW_REPLACE_HISTORY_ITEM_PREFIX = "search_window_replace_history_item_";
    public static final String TAGVWINDOW_WIDTH = "tagv_window_width";
    public static final String TAGVWINDOW_HEIGHT = "tagv_window_height";
    public static final String TAGVWINDOW_X = "tagv_window_x";
    public static final String TAGVWINDOW_Y = "tagv_window_y";
    public static final String HELPWINDOW_WIDTH = "help_window_width";
    public static final String HELPWINDOW_HEIGHT = "help_window_height";
    public static final String HELPWINDOW_X = "help_window_x";
    public static final String HELPWINDOW_Y = "help_window_y";
    public static final String USE_TAB_TO_ADVANCE = "tab_advance";
    public static final String ALWAYS_CONFIRM_QUIT = "always_confirm_quit";
    public static final String ALLOW_GOOGLE_TRANSLATE = "allow_google_translate";
    public static final String ALLOW_GOOGLE2_TRANSLATE = "allow_google2_translate";
    public static final String ALLOW_BELAZAR_TRANSLATE = "allow_belazar_translate";
    public static final String ALLOW_APERTIUM_TRANSLATE = "allow_apertium_translate";
    public static final String ALLOW_MICROSOFT_TRANSLATE = "allow_microsoft_translate";
    public static final String ALLOW_MYMEMORY_HUMAN_TRANSLATE = "allow_mymemory_human_translate";
    public static final String ALLOW_MYMEMORY_MACHINE_TRANSLATE = "allow_mymemory_machine_translate";
    public static final String ALLOW_YANDEX_TRANSLATE = "allow_yandex_translate";
    public static final String TRANSTIPS = "transtips";
    public static final String TRANSTIPS_EXACT_SEARCH = "transtips_exact_search";
    public static final String MARK_NOTED_SEGMENTS = "mark_noted_segments";
    public static final String MARK_NBSP = "mark_nbsp";
    public static final String MARK_WHITESPACE = "mark_whitespace";
    public static final String MARK_BIDI = "mark_bidi";
    public static final String FONT_FALLBACK = "font_fallback";
    public static final String MARK_TRANSLATED_SEGMENTS = "mark_translated_segments";
    public static final String MARK_AUTOPOPULATED = "mark_autopopulated";
    public static final String MARK_UNTRANSLATED_SEGMENTS = "mark_untranslated_segments";
    public static final String DONT_INSERT_SOURCE_TEXT = "wf_noSourceText";
    public static final String ALLOW_TRANS_EQUAL_TO_SRC = "wf_allowTransEqualToSrc";
    public static final String BEST_MATCH_INSERT = "wf_insertBestMatch";
    public static final String BEST_MATCH_MINIMAL_SIMILARITY = "wf_minimalSimilarity";
    public static final String BEST_MATCH_MINIMAL_SIMILARITY_DEFAULT = "80";
    public static final String BEST_MATCH_EXPLANATORY_TEXT = "wf_explanatoryText";
    public static final String EXPORT_CURRENT_SEGMENT = "wf_exportCurrentSegment";
    public static final String STOP_ON_ALTERNATIVE_TRANSLATION = "wf_stopOnAlternativeTranslation";
    public static final String CONVERT_NUMBERS = "wf_convertNumbers";
    public static final String SAVE_AUTO_STATUS = "save_auto_status";
    public static final String DONT_CHECK_PRINTF_TAGS = "tagValidation_noCheck";
    public static final String CHECK_SIMPLE_PRINTF_TAGS = "tagValidation_simpleCheck";
    public static final String CHECK_ALL_PRINTF_TAGS = "tagValidation_elaborateCheck";
    public static final String CHECK_JAVA_PATTERN_TAGS = "tagValidation_javaMessageFormatSimplePatternCheck";
    public static final String CHECK_CUSTOM_PATTERN = "tagValidation_customPattern";
    public static final String CHECK_REMOVE_PATTERN = "tagValidation_removePattern";
    public static final String ALLOW_TAG_EDITING = "allowTagEditing";
    public static final String TAG_VALIDATE_ON_LEAVE = "tagValidateOnLeave";
    public static final String TEAM_AUTHOR = "team_Author";
    public static final String ALLOW_AUTO_SPELLCHECKING = "allow_auto_spellchecking";
    public static final String SPELLCHECKER_DICTIONARY_DIRECTORY = "spellcheker_dir";
    public static final String SPELLCHECKER_DICTIONARY_URL = "dictionary_url";
    public static final String SCRIPTS_DIRECTORY = "scripts_dir";
    public static final String SCRIPTS_QUICK_PREFIX = "scripts_quick_";
    public static final String SCRIPTS_QUICK_1 = "scripts_quick_1";
    public static final String SCRIPTS_QUICK_2 = "scripts_quick_2";
    public static final String SCRIPTS_QUICK_3 = "scripts_quick_3";
    public static final String SCRIPTS_QUICK_4 = "scripts_quick_4";
    public static final String SCRIPTS_QUICK_5 = "scripts_quick_5";
    public static final String SCRIPTS_QUICK_6 = "scripts_quick_6";
    public static final String SCRIPTS_QUICK_7 = "scripts_quick_7";
    public static final String SCRIPTS_QUICK_8 = "scripts_quick_8";
    public static final String SCRIPTS_QUICK_9 = "scripts_quick_9";
    public static final String SCRIPTS_QUICK_0 = "scripts_quick_0";
    public static final String SCRIPTWINDOW_WIDTH = "script_window_width";
    public static final String SCRIPTWINDOW_HEIGHT = "script_window_height";
    public static final String SCRIPTWINDOW_X = "script_window_x";
    public static final String SCRIPTWINDOW_Y = "script_window_y";
    public static final String MOST_RECENT_PROJECTS_SIZE = "most_recent_projects_size";
    public static final String MOST_RECENT_PROJECTS_PREFIX = "most_recent_projects_";
    public static final String DISPLAY_SEGMENT_SOURCES = "display_segment_sources";
    public static final String MARK_NON_UNIQUE_SEGMENTS = "mark_non_unique_segments";
    public static final String DISPLAY_MODIFICATION_INFO = "display_modification_info";
    public static final String EXT_TMX_SHOW_LEVEL2 = "ext_tmx_show_level2";
    public static final String EXT_TMX_USE_SLASH = "ext_tmx_use_slash";
    public static final String EXT_TMX_MATCH_TEMPLATE = "ext_tmx_match_template";
    public static final String EXT_TMX_SORT_KEY = "ext_tmx_sort_key";
    public static final String VIEW_OPTION_SOURCE_ALL_BOLD = "view_option_source_all_bold";
    public static final String VIEW_OPTION_UNIQUE_FIRST = "view_option_unique_first";
    public static final String VIEW_OPTION_PPT_SIMPLIFY = "view_option_ppt_simplify";
    public static final String VIEW_OPTION_TEMPLATE_ACTIVE = "view_option_template_active";
    public static final String VIEW_OPTION_MOD_INFO_TEMPLATE = "view_option_mod_info_template";
    public static final String VIEW_OPTION_MOD_INFO_TEMPLATE_WO_DATE = "view_option_mod_info_template_wo_date";
    public static final String PROXY_USER_NAME = "proxy_user_name";
    public static final String PROXY_PASSWORD = "proxy_password";
    public static final String AUTO_SAVE_INTERVAL = "auto_save_interval";
    public static final String AUTO_SAVE_DEFAULT = "180";
    public static final String EXTERNAL_COMMAND = "external_command";
    public static final String ALLOW_PROJECT_EXTERN_CMD = "allow_project_extern_cmd";
    public static final String FILTERS_VERSION = "filters_version";
    public static final String LT_DISABLED = "lt_disabled";
    public static final String LOOSE_TAG_ORDERING = "loose_tag_ordering";
    public static final String TAGS_VALID_REQUIRED = "tags_valid_required";
    public static final String STAT_COUNTING_PROTECTED_TEXT = "stat_counting_protected_text";
    public static final String STAT_COUNTING_CUSTOM_TAGS = "stat_counting_custom_tags";
    public static final String TOK_BEHAVIOR_PREFIX = "tokenizer_behavior_";
    public static final String AC_SHOW_SUGGESTIONS_AUTOMATICALLY = "ac_show_suggestions_automatically";
    public static final String AC_GLOSSARY_SHOW_SOURCE = "ac_glossary_show_source";
    public static final String AC_GLOSSARY_SHOW_TARGET_BEFORE_SOURCE = "ac_glossary_show_target_before_source";
    public static final String AC_GLOSSARY_SORT_BY_SOURCE = "ac_glossary_sort_by_source";
    public static final String AC_GLOSSARY_SORT_BY_LENGTH = "ac_glossary_sort_by_length";
    public static final String AC_GLOSSARY_SORT_ALPHABETICALLY = "ac_glossary_sort_alphabetically";
    public static final String AC_GLOSSARY_CAPITALIZE = "ac_glossary_capitalize";
    public static final String AC_AUTOTEXT_FILE_NAME = "omegat.autotext";
    public static final String AC_AUTOTEXT_SORT_BY_LENGTH = "ac_autotext_sort_by_length";
    public static final String AC_AUTOTEXT_SORT_ALPHABETICALLY = "ac_autotext_sort_alphabetically";
    public static final String AC_AUTOTEXT_SORT_FULL_TEXT = "ac_autotext_sort_full_text";
    public static final String AC_CHARTABLE_USE_CUSTOM_CHARS = "ac_chartable_use_custom_chars";
    public static final String AC_CHARTABLE_CUSTOM_CHAR_STRING = "ac_chartable_custom_char_string";
    public static final String AC_CHARTABLE_UNIQUE_CUSTOM_CHARS = "ac_chartable_unique_custom_chars";
    public static final String SB_PROGRESS_MODE = "sb_progress_mode";
    public static final String TAAS_LOOKUP = "taas_lookup";
    public static final String TAAS_DOMAIN = "taas_domain";
    private static boolean m_loaded = false;
    private static boolean m_changed;
    private static List<String> m_nameList;
    private static List<String> m_valList;
    private static Map<String, Integer> m_preferenceMap;
    private static SRX srx;

    public static String getPreference(String key) {
        if (key == null || key.equals("")) {
            return "";
        }
        if (!m_loaded) {
            Preferences.doLoad();
        }
        Integer i = m_preferenceMap.get(key);
        String v = "";
        if (i != null) {
            v = m_valList.get(i);
        }
        return v;
    }

    public static boolean existsPreference(String key) {
        Integer i;
        boolean exists = false;
        if (key == null) {
            exists = false;
        }
        if (!m_loaded) {
            Preferences.doLoad();
        }
        if ((i = m_preferenceMap.get(key)) != null) {
            exists = true;
        }
        return exists;
    }

    public static boolean isPreference(String key) {
        return "true".equals(Preferences.getPreference(key));
    }

    public static boolean isPreferenceDefault(String key, boolean defaultValue) {
        String val = Preferences.getPreference(key);
        if (StringUtil.isEmpty(val)) {
            Preferences.setPreference(key, defaultValue);
            return defaultValue;
        }
        return "true".equals(val);
    }

    public static String getPreferenceDefault(String key, String defaultValue) {
        String val = Preferences.getPreference(key);
        if (val.equals("")) {
            val = defaultValue;
            Preferences.setPreference(key, defaultValue);
        }
        return val;
    }

    public static <T extends Enum<T>> T getPreferenceEnumDefault(String key, T defaultValue) {
        T r;
        String val = Preferences.getPreference(key);
        try {
            r = Enum.valueOf(defaultValue.getDeclaringClass(), val);
        }
        catch (IllegalArgumentException ex) {
            r = defaultValue;
            Preferences.setPreference(key, defaultValue);
        }
        return r;
    }

    public static String getPreferenceDefaultAllowEmptyString(String key) {
        String val = Preferences.getPreference(key);
        return val;
    }

    public static int getPreferenceDefault(String key, int defaultValue) {
        String val = Preferences.getPreferenceDefault(key, Integer.toString(defaultValue));
        int res = defaultValue;
        try {
            res = Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return res;
    }

    public static void setPreference(String name, String value) {
        m_changed = true;
        if (!StringUtil.isEmpty(name) && value != null) {
            Integer i;
            if (!m_loaded) {
                Preferences.doLoad();
            }
            if ((i = m_preferenceMap.get(name)) == null) {
                i = m_valList.size();
                m_preferenceMap.put(name, i);
                m_valList.add(value);
                m_nameList.add(name);
            } else {
                m_valList.set(i, value);
            }
        }
    }

    public static void setPreference(String name, Enum<?> value) {
        m_changed = true;
        if (!StringUtil.isEmpty(name) && value != null) {
            Integer i;
            if (!m_loaded) {
                Preferences.doLoad();
            }
            if ((i = m_preferenceMap.get(name)) == null) {
                i = m_valList.size();
                m_preferenceMap.put(name, i);
                m_valList.add(value.name());
                m_nameList.add(name);
            } else {
                m_valList.set(i, value.name());
            }
        }
    }

    public static void setPreference(String name, boolean boolvalue) {
        Preferences.setPreference(name, String.valueOf(boolvalue));
    }

    public static void setPreference(String name, int intvalue) {
        Preferences.setPreference(name, String.valueOf(intvalue));
    }

    public static SRX getSRX() {
        return srx;
    }

    public static void setSRX(SRX newSrx) {
        srx = newSrx;
        File srxFile = new File(StaticUtils.getConfigDir() + "segmentation.conf");
        try {
            SRX.saveTo(srx, srxFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void save() {
        try {
            if (m_changed) {
                Preferences.doSave();
            }
        }
        catch (IOException e) {
            Log.logErrorRB("PM_ERROR_SAVE", new Object[0]);
            Log.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doLoad() {
        m_loaded = true;
        XMLStreamReader xml = new XMLStreamReader();
        xml.killEmptyBlocks();
        File prefsFile = Preferences.getPreferencesFile();
        try {
            if (prefsFile == null) {
                InputStream is = Preferences.class.getResourceAsStream(FILE_PREFERENCES);
                if (is != null) {
                    xml.setStream(new BufferedReader(new InputStreamReader(is)));
                    Preferences.readXmlPrefs(xml);
                }
            } else {
                xml.setStream(prefsFile);
                Preferences.readXmlPrefs(xml);
            }
        }
        catch (TranslationException te) {
            Log.logWarningRB("PM_WARNING_PARSEERROR_ON_READ", new Object[0]);
            Log.log(te);
            Preferences.makeBackup(prefsFile);
        }
        catch (IndexOutOfBoundsException e3) {
            Log.logWarningRB("PM_WARNING_PARSEERROR_ON_READ", new Object[0]);
            Log.log(e3);
            Preferences.makeBackup(prefsFile);
        }
        catch (UnsupportedEncodingException e3) {
            Log.logErrorRB(e3, "PM_UNSUPPORTED_ENCODING", new Object[0]);
            Preferences.makeBackup(prefsFile);
        }
        catch (IOException e4) {
            Log.logErrorRB(e4, "PM_ERROR_READING_FILE", new Object[0]);
            Preferences.makeBackup(prefsFile);
        }
        finally {
            try {
                xml.close();
            }
            catch (IOException ex) {
                Log.log(ex);
            }
        }
        File srxFile = new File(StaticUtils.getConfigDir() + "segmentation.conf");
        srx = SRX.loadSRX(srxFile);
        if (srx == null) {
            srx = SRX.getDefault();
        }
    }

    private static File getPreferencesFile() {
        File prefsFile = new File(StaticUtils.getConfigDir(), FILE_PREFERENCES);
        if (prefsFile.exists()) {
            return prefsFile;
        }
        prefsFile = new File(StaticUtils.installDir(), FILE_PREFERENCES);
        if (prefsFile.exists()) {
            return prefsFile;
        }
        return null;
    }

    private static void readXmlPrefs(XMLStreamReader xml) throws TranslationException {
        m_preferenceMap.clear();
        if (xml.advanceToTag("omegat") == null) {
            return;
        }
        XMLBlock blk = xml.advanceToTag("preference");
        if (blk == null) {
            return;
        }
        String ver = blk.getAttribute("version");
        if (ver != null && !ver.equals("1.0")) {
            return;
        }
        List<XMLBlock> lst = xml.closeBlock(blk);
        if (lst == null) {
            return;
        }
        for (int i = 0; i < lst.size(); ++i) {
            blk = lst.get(i);
            if (blk.isClose() || !blk.isTag()) continue;
            String pref = blk.getTagName();
            String val = (blk = lst.get(++i)).isClose() ? "" : blk.getText();
            if (pref == null || val == null) continue;
            m_preferenceMap.put(pref, m_valList.size());
            m_nameList.add(pref);
            m_valList.add(val);
        }
    }

    private static void makeBackup(File file) {
        if (file == null || !file.isFile()) {
            return;
        }
        String timestamp = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
        File bakFile = new File(file.getAbsolutePath() + "." + timestamp + ".bak");
        try {
            LFileCopy.copy(file, bakFile);
            Log.logWarningRB("PM_BACKED_UP_PREFS_FILE", bakFile.getAbsolutePath());
        }
        catch (IOException ex) {
            Log.logErrorRB(ex, "PM_ERROR_BACKING_UP_PREFS_FILE", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSave() throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(StaticUtils.getConfigDir() + FILE_PREFERENCES), "UTF-8"));
        try {
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            out.write("<omegat>\n");
            out.write("  <preference version=\"1.0\">\n");
            for (int i = 0; i < m_nameList.size(); ++i) {
                String name = m_nameList.get(i);
                String val = StringUtil.makeValidXML(m_valList.get(i));
                out.write("    <" + name + ">");
                out.write(val);
                out.write("</" + name + ">\n");
            }
            out.write("  </preference>\n");
            out.write("</omegat>\n");
        }
        finally {
            out.close();
        }
        m_changed = false;
    }

    static {
        m_preferenceMap = new HashMap<String, Integer>(64);
        m_nameList = new ArrayList<String>(32);
        m_valList = new ArrayList<String>(32);
        m_changed = false;
        Preferences.doLoad();
    }
}

