/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.Locale;

public class StringUtil {
    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isLowerCase(String input) {
        int cp;
        if (input.isEmpty()) {
            return false;
        }
        boolean hasLetters = false;
        for (int i = 0; i < input.length(); i += Character.charCount(cp)) {
            cp = input.codePointAt(i);
            if (!Character.isLetter(cp)) continue;
            hasLetters = true;
            if (Character.isLowerCase(cp)) continue;
            return false;
        }
        return hasLetters;
    }

    public static boolean isUpperCase(String input) {
        int cp;
        if (input.isEmpty()) {
            return false;
        }
        boolean hasLetters = false;
        for (int i = 0; i < input.length(); i += Character.charCount(cp)) {
            cp = input.codePointAt(i);
            if (!Character.isLetter(cp)) continue;
            hasLetters = true;
            if (Character.isUpperCase(cp)) continue;
            return false;
        }
        return hasLetters;
    }

    public static boolean isMixedCase(String input) {
        int cp;
        if (input.isEmpty() || input.codePointCount(0, input.length()) < 2) {
            return false;
        }
        boolean hasUpper = false;
        boolean hasLower = false;
        for (int i = 0; i < input.length(); i += Character.charCount(cp)) {
            cp = input.codePointAt(i);
            if (!Character.isLetter(cp)) continue;
            if (Character.isUpperCase(cp) && i > 0) {
                hasUpper = true;
            } else if (Character.isLowerCase(cp)) {
                hasLower = true;
            }
            if (!hasUpper || !hasLower) continue;
            return true;
        }
        return false;
    }

    public static boolean isTitleCase(String input) {
        if (input.isEmpty()) {
            return false;
        }
        if (input.codePointCount(0, input.length()) > 1) {
            return StringUtil.isTitleCase(input.codePointAt(0)) && StringUtil.isLowerCase(input.substring(input.offsetByCodePoints(0, 1)));
        }
        return StringUtil.isTitleCase(input.codePointAt(0));
    }

    public static boolean isTitleCase(int codePoint) {
        return Character.isTitleCase(codePoint) || Character.isUpperCase(codePoint) && Character.toTitleCase(codePoint) == codePoint;
    }

    public static boolean isWhiteSpace(String input) {
        int cp;
        if (input.isEmpty()) {
            return false;
        }
        for (int i = 0; i < input.length(); i += Character.charCount(cp)) {
            cp = input.codePointAt(i);
            if (StringUtil.isWhiteSpace(cp)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhiteSpace(int codePoint) {
        return Character.isWhitespace(codePoint) || codePoint == 160 || codePoint == 8199 || codePoint == 8239;
    }

    public static boolean isCJK(String input) {
        int cp;
        if (input.isEmpty()) {
            return false;
        }
        for (int i = 0; i < input.length(); i += Character.charCount(cp)) {
            cp = input.codePointAt(i);
            if (cp >= 11904) continue;
            return false;
        }
        return true;
    }

    public static String capitalizeFirst(String text, Locale locale) {
        int remainder = text.offsetByCodePoints(0, 1);
        String firstCP = text.substring(0, remainder);
        return StringUtil.toTitleCase(firstCP, locale) + text.substring(remainder);
    }

    public static String matchCapitalization(String text, String matchTo, Locale locale) {
        if (StringUtil.isEmpty(matchTo)) {
            return text;
        }
        if (text.startsWith(matchTo)) {
            return text;
        }
        if (StringUtil.isTitleCase(matchTo)) {
            return StringUtil.capitalizeFirst(text, locale);
        }
        if (StringUtil.isLowerCase(matchTo) && StringUtil.isUpperCase(text)) {
            return text.toLowerCase(locale);
        }
        if (StringUtil.isUpperCase(matchTo)) {
            return text.toUpperCase(locale);
        }
        return text;
    }

    public static String toTitleCase(String text, Locale locale) {
        if (text.isEmpty()) {
            return text;
        }
        int firstTitleCase = Character.toTitleCase(text.codePointAt(0));
        int remainderOffset = text.offsetByCodePoints(0, 1);
        String first = Character.isTitleCase(firstTitleCase) ? String.valueOf(Character.toChars(firstTitleCase)) : text.substring(0, remainderOffset).toUpperCase(locale);
        return first + text.substring(remainderOffset).toLowerCase(locale);
    }

    public static <T> T nvl(T ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            return values[i];
        }
        return null;
    }

    public static long nvlLong(long ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0L) continue;
            return values[i];
        }
        return 0L;
    }

    public static <T> boolean equalsWithNulls(T v1, T v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 != null && v2 != null) {
            return v1.equals(v2);
        }
        return false;
    }

    public static <T extends Comparable<T>> int compareToWithNulls(T v1, T v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null && v2 != null) {
            return -1;
        }
        if (v1 != null && v2 == null) {
            return 1;
        }
        return v1.compareTo(v2);
    }

    public static String firstN(String str, int len) {
        if (str.length() < len) {
            return str;
        }
        return str.substring(0, len) + "...";
    }

    public static int getFirstLetterLowercase(String s) {
        int cp;
        if (s == null) {
            return 0;
        }
        for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            cp = s.codePointAt(i);
            if (!Character.isLetter(cp)) continue;
            return Character.toLowerCase(cp);
        }
        return 0;
    }

    public static boolean isSubstringAfter(String text, int pos, String substring) {
        if (pos + substring.length() > text.length()) {
            return false;
        }
        return substring.equals(text.substring(pos, pos + substring.length()));
    }

    public static boolean isSubstringBefore(String text, int pos, String substring) {
        if (pos - substring.length() < 0) {
            return false;
        }
        return substring.equals(text.substring(pos - substring.length(), pos));
    }

    public static String stripFromEnd(String string, String ... toStrip) {
        if (string == null) {
            return null;
        }
        if (toStrip == null) {
            return string;
        }
        for (String s : toStrip) {
            if (!string.endsWith(s)) continue;
            string = string.substring(0, string.length() - s.length());
        }
        return string;
    }

    public static String normalizeUnicode(CharSequence text) {
        return Normalizer.isNormalized(text, Normalizer.Form.NFC) ? ((Object)text).toString() : Normalizer.normalize(text, Normalizer.Form.NFC);
    }

    public static String removeXMLInvalidChars(String str) {
        int c;
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); i += Character.charCount(c)) {
            c = str.codePointAt(i);
            if (!StringUtil.isValidXMLChar(c)) {
                c = 32;
            }
            sb.appendCodePoint(c);
        }
        return sb.toString();
    }

    public static boolean isValidXMLChar(int codePoint) {
        if (codePoint < 32) {
            if (codePoint != 9 && codePoint != 10 && codePoint != 13) {
                return false;
            }
        } else if (!(codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF)) {
            return false;
        }
        return true;
    }

    public static String makeValidXML(String plaintext) {
        int cp;
        StringBuilder out = new StringBuilder();
        String text = StringUtil.removeXMLInvalidChars(plaintext);
        for (int i = 0; i < text.length(); i += Character.charCount(cp)) {
            cp = text.codePointAt(i);
            out.append(StringUtil.escapeXMLChars(cp));
        }
        return out.toString();
    }

    public static String compressSpaces(String str) {
        int cp;
        int strlen = str.length();
        StringBuilder res = new StringBuilder(strlen);
        boolean wasspace = true;
        for (int i = 0; i < strlen; i += Character.charCount(cp)) {
            cp = str.codePointAt(i);
            if (Character.isWhitespace(cp)) {
                if (wasspace) continue;
                wasspace = true;
                continue;
            }
            if (wasspace && res.length() > 0) {
                res.append(' ');
            }
            res.appendCodePoint(cp);
            wasspace = false;
        }
        return res.toString();
    }

    public static String escapeXMLChars(int cp) {
        switch (cp) {
            case 38: {
                return "&amp;";
            }
            case 62: {
                return "&gt;";
            }
            case 60: {
                return "&lt;";
            }
            case 34: {
                return "&quot;";
            }
        }
        return String.valueOf(Character.toChars(cp));
    }

    public static String unescapeXMLEntities(String text) {
        if (text.contains("&gt;")) {
            text = text.replaceAll("&gt;", ">");
        }
        if (text.contains("&lt;")) {
            text = text.replaceAll("&lt;", "<");
        }
        if (text.contains("&quot;")) {
            text = text.replaceAll("&quot;", "\"");
        }
        if (text.contains("&amp;")) {
            text = text.replaceAll("&amp;", "&");
        }
        return text;
    }

    public static boolean equal(String one, String two) {
        return one == null && two == null || one != null && one.equals(two);
    }

    public static String format(String str, Object ... arguments) {
        str = str.replaceAll("'", "''");
        return MessageFormat.format(str, arguments);
    }

    public static String rstrip(String text) {
        int cp;
        for (int i = text.length(); i >= 0; i -= Character.charCount(cp)) {
            if (i == 0) {
                return "";
            }
            cp = text.codePointBefore(i);
            if (Character.isWhitespace(cp)) continue;
            return text.substring(0, i);
        }
        return text;
    }
}

