/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.kr.KoreanFilter;
import org.apache.lucene.analysis.kr.KoreanTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KoreanAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    private final boolean replaceInvalidAcronym;
    private Set stopSet;
    private boolean bigrammable = true;
    private boolean hasOrigin = true;
    private boolean exactMatch = false;
    public static final String DIC_ENCODING = "UTF-8";
    public static final Set<?> STOP_WORDS_SET;

    static {
        List<String> stopWords = Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with", "\uc774", "\uadf8", "\uc800", "\uac83", "\uc218", "\ub4f1", "\ub4e4", "\ubc0f", "\uc5d0\uc11c", "\uadf8\ub9ac\uace0", "\uadf8\ub798\uc11c", "\ub610", "\ub610\ub294");
        CharArraySet stopSet = new CharArraySet(Version.LUCENE_CURRENT, stopWords.size(), false);
        stopSet.addAll(stopWords);
        STOP_WORDS_SET = CharArraySet.unmodifiableSet((CharArraySet)stopSet);
    }

    public KoreanAnalyzer() {
        this(Version.LUCENE_CURRENT, STOP_WORDS_SET);
    }

    public KoreanAnalyzer(boolean exactMatch) {
        this(Version.LUCENE_CURRENT, STOP_WORDS_SET);
        this.exactMatch = exactMatch;
    }

    public KoreanAnalyzer(Version matchVersion, String[] stopWords) throws IOException {
        this(matchVersion, StopFilter.makeStopSet((Version)matchVersion, (String[])stopWords));
    }

    public KoreanAnalyzer(Version matchVersion) throws IOException {
        this(matchVersion, STOP_WORDS_SET);
    }

    public KoreanAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet((Reader)new InputStreamReader((InputStream)new FileInputStream(stopwords), DIC_ENCODING)));
    }

    public KoreanAnalyzer(Version matchVersion, File stopwords, String encoding) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet((Reader)new InputStreamReader((InputStream)new FileInputStream(stopwords), encoding)));
    }

    public KoreanAnalyzer(Version matchVersion, Reader stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet((Reader)stopwords));
    }

    public KoreanAnalyzer(Version matchVersion, Set<?> stopWords) {
        super(matchVersion, stopWords);
        this.replaceInvalidAcronym = matchVersion.onOrAfter(Version.LUCENE_24);
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        final KoreanTokenizer src = new KoreanTokenizer(this.matchVersion, reader);
        src.setMaxTokenLength(this.maxTokenLength);
        src.setReplaceInvalidAcronym(this.replaceInvalidAcronym);
        KoreanFilter tok = new KoreanFilter((TokenStream)src, this.bigrammable, this.hasOrigin, this.exactMatch);
        tok = new LowerCaseFilter(this.matchVersion, (TokenStream)tok);
        tok = new StopFilter(this.matchVersion, (TokenStream)tok, (Set)this.stopwords);
        return new ReusableAnalyzerBase.TokenStreamComponents(src, (TokenStream)tok){

            protected boolean reset(Reader reader) throws IOException {
                src.setMaxTokenLength(KoreanAnalyzer.this.maxTokenLength);
                return super.reset(reader);
            }
        };
    }

    public void setBigrammable(boolean is) {
        this.bigrammable = is;
    }

    public void setHasOrigin(boolean has) {
        this.hasOrigin = has;
    }
}

