/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.utils.FileUtil;
import org.apache.lucene.analysis.kr.utils.StringEscapeUtil;
import org.apache.lucene.analysis.kr.utils.StringUtil;

public class HanjaUtils {
    private static Map<String, char[]> mapHanja;

    public static synchronized void loadDictionary() throws MorphException {
        try {
            List strList = FileUtil.readLines("org/apache/lucene/analysis/kr/dic/mapHanja.dic", "UTF-8");
            mapHanja = new HashMap<String, char[]>();
            int i = 0;
            while (i < strList.size()) {
                String[] hanInfos;
                if (((String)strList.get(i)).length() >= 1 && ((String)strList.get(i)).indexOf(",") != -1 && (hanInfos = StringUtil.split((String)strList.get(i), ",")).length == 2) {
                    String hanja = StringEscapeUtil.unescapeJava(hanInfos[0]);
                    mapHanja.put(hanja, hanInfos[1].toCharArray());
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new MorphException(e);
        }
    }

    public static char[] convertToHangul(char hanja) throws MorphException {
        if (mapHanja == null) {
            HanjaUtils.loadDictionary();
        }
        if (hanja > '\u9fff' || hanja < '\u3400') {
            return new char[]{hanja};
        }
        return mapHanja.get(new String(new char[]{hanja}));
    }
}

