/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JLabel;

public final class Mnemonics {
    private static final Pattern RE_MNEMONIC_END = Pattern.compile("\\s*\\(&[A-Za-z0-9]\\)(?=[.\\uFF1A]*$)");

    private Mnemonics() {
    }

    public static void setLocalizedText(AbstractButton abstractButton, String string) {
        Mnemonics.setLocalizedText2(abstractButton, string);
    }

    public static void setLocalizedText(JLabel jLabel, String string) {
        Mnemonics.setLocalizedText2(jLabel, string);
    }

    private static void setLocalizedText2(Object object, String string) {
        int n;
        if (string == null) {
            Mnemonics.setText(object, null);
            return;
        }
        if (Mnemonics.isMacOS()) {
            string = RE_MNEMONIC_END.matcher(string).replaceFirst("");
        }
        if ((n = Mnemonics.findMnemonicAmpersand(string)) < 0) {
            Mnemonics.setText(object, string);
            Mnemonics.setMnemonic(object, 0);
        } else {
            Mnemonics.setText(object, string.substring(0, n) + string.substring(n + 1));
            Mnemonics.setMnemonicAndIndex(object, string.charAt(n + 1), n);
        }
    }

    public static int findMnemonicAmpersand(String string) {
        int n = -1;
        do {
            if ((n = string.indexOf(38, n + 1)) < 0 || n + 1 >= string.length() || string.charAt(n + 1) == ' ' || string.charAt(n + 1) == '\'' && n > 0 && string.charAt(n - 1) == '\'') continue;
            return n;
        } while (n >= 0);
        return -1;
    }

    private static void setMnemonicAndIndex(Object object, char c, int n) {
        if (Mnemonics.isMacOS()) {
            Mnemonics.setMnemonic(object, 0);
        } else if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
            Mnemonics.setMnemonic(object, c);
            Mnemonics.setMnemonicIndex(object, n);
        } else {
            int n2 = Mnemonics.getLatinKeycode(c);
            Mnemonics.setMnemonic(object, n2);
            if (n2 != 0) {
                Mnemonics.setMnemonicIndex(object, n);
            }
        }
    }

    private static int getLatinKeycode(char c) {
        try {
            String string = Mnemonics.getBundle().getString("MNEMONIC_" + c);
            if (string.length() == 1) {
                return string.charAt(0);
            }
            return Integer.parseInt(string);
        }
        catch (MissingResourceException missingResourceException) {
            return 0;
        }
    }

    private static void setMnemonicIndex(Object object, int n) {
        if (object instanceof AbstractButton) {
            ((AbstractButton)object).setDisplayedMnemonicIndex(n);
        } else if (object instanceof JLabel) {
            ((JLabel)object).setDisplayedMnemonicIndex(n);
        }
    }

    private static void setText(Object object, String string) {
        if (object instanceof AbstractButton) {
            ((AbstractButton)object).setText(string);
        } else {
            ((JLabel)object).setText(string);
        }
    }

    private static void setMnemonic(Object object, int n) {
        if (n >= 97 && n <= 122) {
            n += -32;
        }
        if (object instanceof AbstractButton) {
            ((AbstractButton)object).setMnemonic(n);
        } else {
            ((JLabel)object).setDisplayedMnemonic(n);
        }
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle("org.openide.awt.Mnemonics");
    }

    private static boolean isMacOS() {
        return System.getProperty("os.name").contains("OS X");
    }
}

