/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import org.madlonkay.supertmxmerge.DiffController;
import org.madlonkay.supertmxmerge.gui.MapToTextConverter;
import org.madlonkay.supertmxmerge.util.CharDiff;
import org.madlonkay.supertmxmerge.util.LocString;

public class DiffCell
extends JPanel {
    private static final MapToTextConverter CONVERTER = new MapToTextConverter();
    private static final Border BORDER_DEFAULT;
    private JLabel itemNumberLabel;
    private JPanel jPanel2;
    private JTextArea sourceText;
    private JPanel sourceTextPanel;
    private JPanel targetTextsPanel;
    private JTextPane tuvText1;
    private JTextPane tuvText2;

    public DiffCell(int itemNumber, DiffController.DiffInfo info) {
        this.initComponents();
        this.itemNumberLabel.setText(String.valueOf(itemNumber));
        if (info.key.props != null) {
            this.setToolTipText((String)CONVERTER.convertForward(info.key.props));
        }
        this.setSourceLanguage(info.sourceLanguage);
        this.setTargetLanguage(info.targetLanguage);
        this.setTextWithFallback(this.sourceText, info.key.sourceText, "STM_TUV_NOT_PRESENT", null);
        this.setTextWithFallback(this.tuvText1, info.tuv1Text, "STM_TUV_NOT_PRESENT", info.tuv1Props);
        this.setTextWithFallback(this.tuvText2, info.tuv2Text, "STM_TUV_DELETED", info.tuv2Props);
        CharDiff.applyStyling(info.tuv1Text, info.tuv2Text, this.tuvText1, this.tuvText2);
    }

    private void setSourceLanguage(String language) {
        TitledBorder sourceBorder = (TitledBorder)this.sourceTextPanel.getBorder();
        sourceBorder.setTitle(language);
    }

    private void setTargetLanguage(String language) {
        TitledBorder targetBorder = (TitledBorder)this.targetTextsPanel.getBorder();
        targetBorder.setTitle(language);
    }

    private void setTextWithFallback(JTextComponent field, String text, String fallbackKey, Map<String, String> props) {
        if (text == null) {
            field.setBackground(this.getBackground());
            text = LocString.get(fallbackKey);
        }
        if (props != null) {
            field.setToolTipText((String)CONVERTER.convertForward(props));
        }
        field.setText(text);
    }

    private void initComponents() {
        this.itemNumberLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.sourceTextPanel = new JPanel();
        this.sourceText = new JTextArea();
        this.targetTextsPanel = new JPanel();
        this.tuvText1 = new JTextPane();
        this.tuvText2 = new JTextPane();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.itemNumberLabel.setText("n");
        this.itemNumberLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)this.itemNumberLabel, "West");
        this.jPanel2.setLayout(new BorderLayout());
        this.sourceTextPanel.setBorder(BorderFactory.createTitledBorder("Source Language"));
        this.sourceTextPanel.setLayout(new GridLayout(1, 0));
        this.sourceText.setEditable(false);
        this.sourceText.setColumns(72);
        this.sourceText.setFont(UIManager.getDefaults().getFont("Label.font"));
        this.sourceText.setLineWrap(true);
        this.sourceText.setText("Source text");
        this.sourceText.setWrapStyleWord(true);
        this.sourceText.setBorder(BORDER_DEFAULT);
        this.sourceTextPanel.add(this.sourceText);
        this.jPanel2.add((Component)this.sourceTextPanel, "North");
        this.targetTextsPanel.setBorder(BorderFactory.createTitledBorder("Target Language"));
        this.targetTextsPanel.setLayout(new GridLayout(1, 0));
        this.tuvText1.setEditable(false);
        this.tuvText1.setBorder(BORDER_DEFAULT);
        this.tuvText1.setFont(UIManager.getDefaults().getFont("Label.font"));
        this.tuvText1.setText("Target text 1");
        this.targetTextsPanel.add(this.tuvText1);
        this.tuvText2.setEditable(false);
        this.tuvText2.setBorder(BORDER_DEFAULT);
        this.tuvText2.setFont(UIManager.getDefaults().getFont("Label.font"));
        this.tuvText2.setText("Target text 2");
        this.targetTextsPanel.add(this.tuvText2);
        this.jPanel2.add((Component)this.targetTextsPanel, "Center");
        this.add((Component)this.jPanel2, "Center");
    }

    static {
        JScrollPane sp = new JScrollPane();
        BORDER_DEFAULT = sp.getBorder();
    }
}

