/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.madlonkay.supertmxmerge.MergeController;
import org.madlonkay.supertmxmerge.data.Key;
import org.madlonkay.supertmxmerge.gui.BorderConverter;
import org.madlonkay.supertmxmerge.gui.ClickForwarder;
import org.madlonkay.supertmxmerge.gui.MapToTextConverter;
import org.madlonkay.supertmxmerge.util.CharDiff;
import org.madlonkay.supertmxmerge.util.LocString;

public class MergeCell
extends JPanel {
    private static final Border BORDER_DEFAULT;
    private static final Border BORDER_SELECTED;
    private static final MapToTextConverter CONVERTER;
    private final MergeController.ConflictInfo info;
    private final boolean isDetailMode;
    private BorderConverter borderConverter1;
    private ButtonGroup buttonGroup;
    private JRadioButton centerButton;
    private JLabel itemNumberLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton leftButton;
    private JRadioButton rightButton;
    private JPanel sourceTargetPanel;
    private JTextArea sourceText;
    private JTextPane tuvTextCenter;
    private JTextPane tuvTextLeft;
    private JTextPane tuvTextRight;
    private BindingGroup bindingGroup;

    public MergeCell(int itemNumber, MergeController.ConflictInfo info, boolean isDetailMode) {
        this.initComponents();
        this.isDetailMode = isDetailMode;
        this.info = info;
        this.itemNumberLabel.setText(String.valueOf(itemNumber));
        this.sourceText.setText(info.key.sourceText);
        if (info.key.props != null) {
            this.setToolTipText((String)CONVERTER.convertForward(info.key.props));
        }
        this.setSourceLanguage(info.sourceLanguage);
        this.setTargetLanguage(info.targetLanguage);
        String baseText = this.setBaseText(info.baseTuvText, info.baseTuvProps);
        String leftText = this.setLeftText(info.leftTuvText, info.leftTuvProps, info.baseTuvText != null);
        String rightText = this.setRightText(info.rightTuvText, info.rightTuvProps, info.baseTuvText != null);
        this.tuvTextLeft.addMouseListener(new ClickForwarder(this.leftButton));
        this.tuvTextRight.addMouseListener(new ClickForwarder(this.rightButton));
        this.tuvTextCenter.addMouseListener(new ClickForwarder(this.centerButton));
        if (info.baseTuvText == null) {
            CharDiff.applyStyling(leftText, rightText, this.tuvTextLeft, this.tuvTextRight);
        } else {
            CharDiff.applyStyling(baseText, leftText, this.tuvTextCenter, this.tuvTextLeft);
            CharDiff.applyStyling(baseText, rightText, this.tuvTextCenter, this.tuvTextRight, true);
        }
        if (isDetailMode) {
            this.itemNumberLabel.setVisible(false);
        }
    }

    private void setSourceLanguage(String language) {
        TitledBorder sourceBorder = (TitledBorder)this.jPanel2.getBorder();
        sourceBorder.setTitle(language);
    }

    private void setTargetLanguage(String language) {
        TitledBorder targetBorder = (TitledBorder)this.jPanel1.getBorder();
        targetBorder.setTitle(language);
    }

    private String setBaseText(String text, Map<String, String> props) {
        boolean disableCharDiff = false;
        if (text == null) {
            this.tuvTextCenter.setBackground(this.getBackground());
            text = LocString.get("STM_TUV_NOT_PRESENT");
            disableCharDiff = true;
        }
        if (props != null) {
            if (this.isDetailMode) {
                text = text + "\n\n" + MapToTextConverter.mapToPlainText(props);
            } else {
                this.tuvTextCenter.setToolTipText(MapToTextConverter.mapToHtml(props));
            }
        }
        this.tuvTextCenter.setText(text);
        return disableCharDiff ? null : text;
    }

    private String setLeftText(String text, Map<String, String> props, boolean presentInBase) {
        boolean disableCharDiff = false;
        if (text == null) {
            this.tuvTextLeft.setBackground(this.getBackground());
            text = presentInBase ? LocString.get("STM_TUV_DELETED") : LocString.get("STM_TUV_NOT_PRESENT");
            disableCharDiff = true;
        }
        if (props != null) {
            if (this.isDetailMode) {
                text = text + "\n\n" + MapToTextConverter.mapToPlainText(props);
            } else {
                this.tuvTextLeft.setToolTipText(MapToTextConverter.mapToHtml(props));
            }
        }
        this.tuvTextLeft.setText(text);
        return disableCharDiff ? null : text;
    }

    private String setRightText(String text, Map<String, String> props, boolean presentInBase) {
        boolean disableCharDiff = false;
        if (text == null) {
            this.tuvTextRight.setBackground(this.getBackground());
            text = presentInBase ? LocString.get("STM_TUV_DELETED") : LocString.get("STM_TUV_NOT_PRESENT");
            disableCharDiff = true;
        }
        if (props != null) {
            if (this.isDetailMode) {
                text = text + "\n\n" + MapToTextConverter.mapToPlainText(props);
            } else {
                this.tuvTextRight.setToolTipText(MapToTextConverter.mapToHtml(props));
            }
        }
        this.tuvTextRight.setText(text);
        return disableCharDiff ? null : text;
    }

    public AbstractButton[] getButtons() {
        return new AbstractButton[]{this.leftButton, this.centerButton, this.rightButton};
    }

    public Key getKey() {
        return this.info.key;
    }

    public void setIsTwoWayMerge(boolean isTwoWayMerge) {
        if (isTwoWayMerge) {
            this.jPanel1.remove(this.tuvTextCenter);
        } else {
            this.jPanel1.add((Component)this.tuvTextCenter, 1);
        }
    }

    public boolean isSelectionPerformed() {
        return this.leftButton.getModel().isSelected() || this.rightButton.getModel().isSelected() || this.centerButton.getModel().isSelected();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.buttonGroup = new ButtonGroup();
        this.borderConverter1 = new BorderConverter(BORDER_SELECTED, BORDER_DEFAULT);
        this.leftButton = new JRadioButton();
        this.centerButton = new JRadioButton();
        this.rightButton = new JRadioButton();
        this.itemNumberLabel = new JLabel();
        this.sourceTargetPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.sourceText = new JTextArea();
        this.jPanel1 = new JPanel();
        this.tuvTextLeft = new JTextPane();
        this.tuvTextCenter = new JTextPane();
        this.tuvTextRight = new JTextPane();
        this.buttonGroup.add(this.leftButton);
        this.leftButton.setContentAreaFilled(false);
        this.buttonGroup.add(this.centerButton);
        this.centerButton.setContentAreaFilled(false);
        this.centerButton.setHorizontalAlignment(0);
        this.buttonGroup.add(this.rightButton);
        this.rightButton.setContentAreaFilled(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.itemNumberLabel.setText("n");
        this.itemNumberLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)this.itemNumberLabel, "West");
        this.sourceTargetPanel.setLayout(new BorderLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Source Language"));
        this.jPanel2.setLayout(new GridLayout(1, 0));
        this.sourceText.setEditable(false);
        this.sourceText.setColumns(72);
        this.sourceText.setFont(UIManager.getDefaults().getFont("Label.font"));
        this.sourceText.setLineWrap(true);
        this.sourceText.setText("Source text");
        this.sourceText.setWrapStyleWord(true);
        this.sourceText.setBorder(BORDER_DEFAULT);
        this.jPanel2.add(this.sourceText);
        this.sourceTargetPanel.add((Component)this.jPanel2, "North");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Target Language"));
        this.jPanel1.setLayout(new GridLayout(1, 0));
        this.tuvTextLeft.setEditable(false);
        this.tuvTextLeft.setFont(UIManager.getDefaults().getFont("Label.font"));
        this.tuvTextLeft.setText("Target text 1");
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.leftButton, ELProperty.create("${selected}"), this.tuvTextLeft, BeanProperty.create("border"), "tuvTextLeftBorder");
        binding.setConverter(this.borderConverter1);
        this.bindingGroup.addBinding(binding);
        this.jPanel1.add(this.tuvTextLeft);
        this.tuvTextCenter.setEditable(false);
        this.tuvTextCenter.setFont(UIManager.getDefaults().getFont("Label.font"));
        this.tuvTextCenter.setText("Target text 2");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.centerButton, ELProperty.create("${selected}"), this.tuvTextCenter, BeanProperty.create("border"), "tuvTextCenterBorder");
        binding.setConverter(this.borderConverter1);
        this.bindingGroup.addBinding(binding);
        this.jPanel1.add(this.tuvTextCenter);
        this.tuvTextRight.setEditable(false);
        this.tuvTextRight.setFont(UIManager.getDefaults().getFont("Label.font"));
        this.tuvTextRight.setText("Target text 3");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.rightButton, ELProperty.create("${selected}"), this.tuvTextRight, BeanProperty.create("border"), "tuvTextRightBorder");
        binding.setConverter(this.borderConverter1);
        this.bindingGroup.addBinding(binding);
        this.jPanel1.add(this.tuvTextRight);
        this.sourceTargetPanel.add((Component)this.jPanel1, "Center");
        this.add((Component)this.sourceTargetPanel, "Center");
        this.bindingGroup.bind();
    }

    static {
        CONVERTER = new MapToTextConverter();
        JScrollPane sp = new JScrollPane();
        BORDER_DEFAULT = sp.getBorder();
        BORDER_SELECTED = new MatteBorder(2, 2, 2, 2, Color.BLUE);
    }
}

