/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class SimpleReplaceRule
extends Rule {
    private static final String FILE_ENCODING = "utf-8";
    private static final String FILE_NAME = "/uk/replace.txt";
    private final Map<String, List<String>> wrongWords;

    public final String getFileName() {
        return FILE_NAME;
    }

    public SimpleReplaceRule(ResourceBundle messages) throws IOException {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
        this.wrongWords = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(this.getFileName()));
    }

    public final String getId() {
        return "UK_SIMPLE_REPLACE";
    }

    public String getDescription() {
        return "\u041f\u043e\u0448\u0443\u043a \u043f\u043e\u043c\u0438\u043b\u043a\u043e\u0432\u0438\u0445 \u0441\u043b\u0456\u0432";
    }

    public String getShort() {
        return "\u041f\u043e\u043c\u0438\u043b\u043a\u0430?";
    }

    public String getSuggestion() {
        return " - \u043f\u043e\u043c\u0438\u043b\u043a\u043e\u0432\u0435 \u0441\u043b\u043e\u0432\u043e, \u0432\u0438\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044f: ";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public String getEncoding() {
        return FILE_ENCODING;
    }

    private String cleanup(String word) {
        if (!this.isCaseSensitive()) {
            word = word.toLowerCase(this.getLocale());
        }
        return word;
    }

    public final RuleMatch[] match(AnalyzedSentence text) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings tokenReadings : tokens = text.getTokensWithoutWhitespace()) {
            List<String> replacements;
            String tokenString = this.cleanup(tokenReadings.getToken());
            if (!this.wrongWords.containsKey(tokenString)) {
                for (AnalyzedToken analyzedToken : tokenReadings.getReadings()) {
                    String lemma = analyzedToken.getLemma();
                    if (lemma == null || !this.wrongWords.containsKey(lemma = this.cleanup(lemma))) continue;
                    tokenString = lemma;
                    break;
                }
            }
            if ((replacements = this.wrongWords.get(tokenString)) == null || replacements.size() <= 0) continue;
            RuleMatch potentialRuleMatch = this.createRuleMatch(tokenReadings, replacements);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private RuleMatch createRuleMatch(AnalyzedTokenReadings tokenReadings, List<String> replacements) {
        String tokenString;
        String origToken = tokenString = tokenReadings.getToken();
        String msg = tokenString + this.getSuggestion() + StringUtils.join(replacements, (String)", ");
        int pos = tokenReadings.getStartPos();
        RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, pos, pos + origToken.length(), msg, this.getShort());
        if (!this.isCaseSensitive() && StringTools.startsWithUppercase((String)tokenString)) {
            for (int i = 0; i < replacements.size(); ++i) {
                replacements.set(i, StringTools.uppercaseFirstChar((String)replacements.get(i)));
            }
        }
        potentialRuleMatch.setSuggestedReplacements(replacements);
        return potentialRuleMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> loadWords(InputStream stream) throws IOException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Scanner scanner = new Scanner(stream, this.getEncoding());
        try {
            while (scanner.hasNextLine()) {
                String[] parts;
                String line = scanner.nextLine();
                if (line.length() < 1 || line.charAt(0) == '#') continue;
                if (!this.isCaseSensitive()) {
                    line = line.toLowerCase(this.getLocale());
                }
                if ((parts = line.split("=")).length != 2) {
                    throw new IOException("Format error in file " + JLanguageTool.getDataBroker().getFromRulesDirAsUrl(this.getFileName()) + ", line: " + line);
                }
                String[] replacements = parts[1].split("\\|");
                map.put(parts[0], Arrays.asList(replacements));
            }
        }
        finally {
            scanner.close();
        }
        return map;
    }

    public void reset() {
    }
}

