/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNCharsetConvertor;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;

public class SVNCharsetInputStream
extends FilterInputStream {
    private static final int DEFAULT_BUFFER_CAPACITY = 1024;
    private SVNCharsetConvertor myCharsetConvertor;
    private byte[] mySourceBuffer;
    private ByteBuffer myConvertedBuffer;
    private boolean myEndOfStream;

    public SVNCharsetInputStream(InputStream in, Charset inputCharset, Charset outputCharset, CodingErrorAction malformedInputAction, CodingErrorAction unmappableCharAction) {
        super(in);
        CharsetDecoder decoder = inputCharset.newDecoder();
        decoder.onMalformedInput(malformedInputAction);
        decoder.onUnmappableCharacter(unmappableCharAction);
        CharsetEncoder encoder = outputCharset.newEncoder();
        encoder.onMalformedInput(malformedInputAction);
        encoder.onUnmappableCharacter(unmappableCharAction);
        this.myCharsetConvertor = new SVNCharsetConvertor(decoder, encoder);
        this.mySourceBuffer = new byte[1024];
        this.myConvertedBuffer = ByteBuffer.allocate(1024);
        this.myEndOfStream = false;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int r = this.read(b);
        if (r < 0) {
            return -1;
        }
        return b[0];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] b, int off, int len) throws IOException {
        int available = this.myConvertedBuffer.position();
        if (this.myEndOfStream && available == 0) {
            return -1;
        }
        while (available < len) {
            Object var8_6;
            block6: {
                int readed = this.fillBuffer();
                try {
                    try {
                        this.myConvertedBuffer = this.myCharsetConvertor.convertChunk(this.mySourceBuffer, 0, readed, this.myConvertedBuffer, this.myEndOfStream);
                        if (!this.myEndOfStream) break block6;
                        this.myConvertedBuffer = this.myCharsetConvertor.flush(this.myConvertedBuffer);
                        var8_6 = null;
                    }
                    catch (SVNException e) {
                        throw new IOExceptionWrapper(e);
                    }
                }
                catch (Throwable throwable) {
                    var8_6 = null;
                    available = this.myConvertedBuffer.position();
                    throw throwable;
                }
                available = this.myConvertedBuffer.position();
                break;
            }
            var8_6 = null;
            available = this.myConvertedBuffer.position();
        }
        this.myConvertedBuffer.flip();
        len = Math.min(this.myConvertedBuffer.remaining(), len);
        this.myConvertedBuffer = this.myConvertedBuffer.get(b, off, len);
        this.myConvertedBuffer = this.myConvertedBuffer.compact();
        return len;
    }

    private int fillBuffer() throws IOException {
        int readed;
        int r;
        for (readed = 0; readed < this.mySourceBuffer.length; readed += r) {
            r = this.in.read(this.mySourceBuffer, readed, this.mySourceBuffer.length - readed);
            if (r >= 0) continue;
            this.myEndOfStream = true;
            break;
        }
        return readed;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SVNCharsetInputStream");
        buffer.append("[").append(this.myCharsetConvertor);
        buffer.append(']');
        return buffer.toString();
    }
}

