// package hldswrth.controls;
// by Simon Holdsworth, Object Technology Products, Hursley
// HLDSWRTH at WINVMD
// Modified by Marc Fiammante
// to add a bounding 3D rect and center the image to mimic PM behaviour
//
import java.awt.*;

//------------------------------------------------------------------------------
// CLASS:      ImageButton
//
// EXTENDS:    Canvas
//
// IMPLEMENTS:
//
// DESCRIPTION:
//
/**  This class provides a base implementation for buttons which use images
 *   for their display.
*///----------------------------------------------------------------------------

public class ImageButton extends Canvas
  {
  Image down_image = null;
  Image up_image = null;
  Image disabled_image = null;
  boolean down = false;
  boolean selected = false;
  boolean disabled = false;
  boolean focus = false;
  Graphics viewed_graphics;

//------------------------------------------------------------------------------
// METHOD: ImageButton.ImageButton
//
// DESCRIPTION:
//
/**  Constructs an ImageButton, given an image for the button display.
*///----------------------------------------------------------------------------

  public ImageButton( Image up_img )
    {
    up_image = up_img;
    }

//------------------------------------------------------------------------------
// METHOD: ImageButton.ImageButton
//
// DESCRIPTION:
//
/**  Constructs an ImageButton, given an image for the button display and
 *   an image for the button pressed display.
*///----------------------------------------------------------------------------

  public ImageButton( Image up_img, Image down_img )
    {
    up_image = up_img;
    down_image = down_img;
    }

//------------------------------------------------------------------------------
// METHOD: ImageButton.ImageButton
//
// DESCRIPTION:
//
/**  Constructs an ImageButton, given an image for the button display,
 *   an image for the button pressed display and an image for disabled.
*///----------------------------------------------------------------------------

  public ImageButton( Image up_img, Image down_img, Image dis_img )
    {
    up_image = up_img;
    down_image = down_img;
    disabled_image = dis_img;
    }

//------------------------------------------------------------------------------
// METHOD: ImageButton.addNotify
//
// DESCRIPTION:
//
/**  Ensures that the button is sized to the size of the image.  We allow a
 *   single pixel around the image so that the background can show through.
 *   This will be used to highlight the last selected button in a Container.
 *   (Support for this to be added).
*///----------------------------------------------------------------------------

  public void addNotify()
    {
    super.addNotify();
    viewed_graphics = getGraphics();
    /*resize(up_image.getWidth(null)+2,up_image.getHeight(null)+2); */
    }

//------------------------------------------------------------------------------
// METHOD: ImageButton.gotFocus
//
// DESCRIPTION:
//
/**  Sets the background when the button receives the focus.
*///----------------------------------------------------------------------------

  public boolean gotFocus(Event evt, Object target)
    {
    focus = true;
    return true;
    }

//------------------------------------------------------------------------------
// METHOD: ImageButton.lostFocus
//
// DESCRIPTION:
//
/**  Sets the background when the button loses the focus.
*///----------------------------------------------------------------------------

  public boolean lostFocus(Event evt, Object target)
    {
    focus = false;
    paint(viewed_graphics);
    return true;
    }

//------------------------------------------------------------------------------
// METHOD: ImageButton.paint
//
// DESCRIPTION:
//
/**  Draws the required image into the button.
*///----------------------------------------------------------------------------

  public void paint(Graphics g)
    {
     Dimension d=size();
     Color     bg=getBackground();
// Draw the appropriate image for the button's state
     g.setColor(bg);
     g.clearRect(0,0,d.width-1,d.height-1);
     if (down)
       g.draw3DRect(0,0,d.width-1,d.height-1,false);
     else
       g.draw3DRect(0,0,d.width-1,d.height-1,true);

     if( disabled && disabled_image != null )
       g.drawImage(disabled_image,1,1,this);
     else if( down && down_image != null )
       g.drawImage(down_image,1,1,this);
     else {
       if (!down) {
         g.drawImage(up_image,
             (d.width -up_image.getWidth(null))/2,
             (d.height-up_image.getHeight(null))/2,
             this);
       } else {
         g.drawImage(up_image,
             (d.width -up_image.getWidth(null))/2+2,
             (d.height-up_image.getHeight(null))/2+2,
             this);

       }
     }

// Could do something here to indicate focus if necessary.

    if( focus )
      {
//    g.setColor(Color.black);
//    g.drawRect(size().width/3,size().height/3,size().width/3,size().height/3);
      }
    }

//------------------------------------------------------------------------------
// METHOD: ImageButton.mouseDown
//
// DESCRIPTION:
//
/**  Handles a button down event.
*///----------------------------------------------------------------------------

  public boolean mouseDown(Event evt, int x, int y)
    {

// If the button is not disabled, redraw it in the down position.

    if( !disabled )
      {
      down = true;
      paint(viewed_graphics);
      }

    return true;
    }

//------------------------------------------------------------------------------
// METHOD: ImageButton.mouseUp
//
// DESCRIPTION:
//
/**  Handles a button up event.
*///----------------------------------------------------------------------------

  public boolean mouseUp(Event evt, int x, int y)
    {

// If the button is not disabled and is down, redraw it in the up position.
// Post an ACTION event for the button.

    if( !disabled && down )
      {
      down = false;
      paint(viewed_graphics);
      postEvent(new Event(this,Event.ACTION_EVENT,this));
      }

    return true;
    }

//------------------------------------------------------------------------------
// METHOD: ImageButton.mouseDrag
//
// DESCRIPTION:
//
/**  Handles a pointer drag operation.
*///----------------------------------------------------------------------------

  public boolean mouseDrag(Event evt, int x, int y)
    {

// If the button is not disabled, we need to correctly handle the pointer
// leaving the button bounds.

    if( !disabled )
      if( x < 0 || x >= size().width ||
          y < 0 || y >= size().height )
        {

// If the pointer is outside the button, and the button is down, then repaint
// the button in the up position.

        if( down )
          {
          down = false;
          paint(viewed_graphics);
          }
        }

// If the pointer is inside the button, and the button is not down, then repaint
// the button in the down position.

      else if( !down )
        {
        down = true;
        paint(viewed_graphics);
        }

    return true;
    }

//------------------------------------------------------------------------------
// METHOD: ImageButton.enable
//
// DESCRIPTION:
//
/**  Enables the ImageButton.
*///----------------------------------------------------------------------------

  public void enable()
    {

// If button is currently disabled, then enable and repaint it.

    if( disabled )
      {
      disabled = false;
      paint(viewed_graphics);
      }
    }

//------------------------------------------------------------------------------
// METHOD: ImageButton.disable
//
// DESCRIPTION:
//
/**  Disables the ImageButton.
*///----------------------------------------------------------------------------

  public void disable()
    {

// If button is currently enabled, then disable and repaint it.  If the button
// is down when it is disabled, we reset it to the up position.

    if( !disabled )
      {
      disabled = true;
      down = false;
      paint(viewed_graphics);
      }
    }
  }
