/* GroupBox: This class extends the Panel component from java.awt to */
/*    provide a standard GroupBox look.                              */

package extend.awt;

import java.awt.*;

public class GroupBox extends Panel {

   public GroupBox (String text) {

      title = text;
   }

   public void setText (String newText) {

      title = newText;
      repaint ();
   }

   public Insets insets () {

      FontMetrics fm = getFontMetrics (getFont ());

      return new Insets (fm.getHeight () + 2, 5, 5, 5);
   }

   public void paint (Graphics g) {

      FontMetrics fm = getFontMetrics (getFont ());
      int dy = fm.getHeight () / 2;
      Dimension d = size ();

      g.setColor (Color.white);
      g.drawRect (1, dy + 1, d.width - 2, d.height - dy - 2);

      g.setColor (Color.darkGray);
      g.drawRect (0, dy, d.width - 2, d.height - dy - 2);

      if (title != null) {

         g.setColor (getBackground ());
         g.fillRect (dy, 1, fm.stringWidth (title) + 4, fm.getHeight ());

         g.setColor (Color.black);
         g.drawString (title, dy + 2, fm.getHeight () - 2);
      } 
   }

   private String title;
}
