/* ADate: This class provides a date object which gives more useful */
/*    function for dates than the java.util.Date class.             */

package extend.util;

public class ADate {

   private static final String Copyright = 
      "\nLicensed Materials - Property of ISSC,\n" +
      "a wholy owned subsidiary of IBM Corporation.\n" +
      "(C) Copyright Integrated Systems Solutions Corporation 1986\n" +
      "All Rights Reserved US Government Users Restricted Rights.\n";

   public ADate () {

      java.util.Date hold = new java.util.Date ();

      year = hold.getYear () + 1900;
      month = hold.getMonth () + 1;
      day = hold.getDate ();
      value = toLilian (year, month, day);
      separator = "-";
   }

   public ADate (int y, int m, int d) {

      value = toLilian (y, m, d);
      year = y;
      month = m;
      day = d;
      separator = "-";
   }

   private static long toLilian (int y, int m, int d) {

      return (long) (Math.floor ((y - 1501) * 365.25) - 29872 +
                     julianDays (y, m, d) - 
                     Math.floor ((y - 1501) / 100) +
                     Math.floor ((y - 1201) / 400));
   }

   public int getYear () {return year;}

   public int getMonth () {return month;}

   public int getDay () {return day;}

   public void setYear (int y) {

      year = y;
      value = toLilian (year, month, day);
   }

   public void setMonth (int m) {

      month = m;
      value = toLilian (year, month, day);
   }

   public void setDay (int d) {

      day = d;
      value = toLilian (year, month, day);
   }

   public void nextMonth () {

      month++;

      if (month > 12) {

         month = 1;
         year++;
      }

      day = 1;

      value = toLilian (year, month, day);
   }

   public void previousMonth () {

      month--;

      if (month < 1) {

         month = 12;
         year--;
      }

      day = daysInMonth (year, month);

      value = toLilian (year, month, day);
   }

   public boolean equals (ADate theOther) {

      return (this.value == theOther.value);
   }

   public String toString () {

      String sYear = "" + year;
      String sMonth = "" + month;
      String sDay = "" + day;

      if (sDay.length () < 2)
         sDay = "0" + sDay;

      if (sMonth.length () < 2)
         sMonth = "0" + sMonth;

      while (sYear.length () < 4)
         sYear = "0" + sYear;

      return (sYear + separator + sMonth + separator + sDay);
   }

   public String toString (int type) {

      String result = null;
       
      switch (type) {

         case USA:
            result = monthName () + " " + day + ", " + year;
            break;

         case European:
            result = "" + day + " " + monthName () + " " + year;
            break;

         default:
            throw new IllegalArgumentException ("Invalid format type");
      }

      return (result);
   }

   public int toJulian () {

      return (year * 1000) + julianDays (year, month, day);
   }

   private static int julianDays (int y, int m, int d) {

      int result = 0;

      for (int loop = 1; loop < m; loop++)
         result += daysInMonth (y, loop);

      return (result + d);
   }

   public int daysInMonth () {

      return daysInMonth (year, month);
   }

   private static int daysInMonth (int y, int m) {

      int days = 0;

      switch (m) {

         case 1:
         case 3:
         case 5:
         case 7:
         case 8:
         case 10:
         case 12: days = 31; break;

         case 4:
         case 6:
         case 9:
         case 11: days = 30; break;

         case 2:  days = (isLeapYear (y) ? 29 : 28); break;
      }

      return (days);
   }

   public boolean isLeapYear () {

      return isLeapYear (year);
   }

   private static boolean isLeapYear (int y) {

      boolean result = false;

      if ((y % 4) == 0)
         if ((y % 100) == 0)
            result = ((y % 400) == 0);
         else
            result = true;
      else
         result = false;

      return (result);
   }

   public String monthName () {

      return getMonthName (month);
   }

   public static String getMonthName (int month) {

      String result = null;

      switch (month) {

         case  1: result = "January";   break;
         case  2: result = "February";  break;
         case  3: result = "March";     break;
         case  4: result = "April";     break;
         case  5: result = "May";       break;
         case  6: result = "June";      break;
         case  7: result = "July";      break;
         case  8: result = "August";    break;
         case  9: result = "September"; break;
         case 10: result = "October";   break;
         case 11: result = "November";  break;
         case 12: result = "December";  break;
         default:
            throw new IllegalArgumentException ("Invalid month number");
      }

      return result;
   }

   public int dayOfWeek () {

      return (int) ((value + 4) % 7);
   }

   public String weekdayName () {

      return getWeekdayName (dayOfWeek ());
   }

   public static String getWeekdayName (int day) {

      String result = null;

      switch (day) {

         case 0: result = "Sunday";    break;
         case 1: result = "Monday";    break;
         case 2: result = "Tuesday";   break;
         case 3: result = "Wednesday"; break;
         case 4: result = "Thursday";  break;
         case 5: result = "Friday";    break;
         case 6: result = "Saturday";  break;
         default:
            throw new IllegalArgumentException ("Invalid month number");
      }

      return result;
   }

   public void setSeparator (String newSeparator) {

      if (newSeparator == null)
         throw new IllegalArgumentException ("Null separator is not allowed.");

      separator = newSeparator;
   }

   private long value;
   private int year;
   private int month;
   private int day;
   private String separator;

   public static final int USA = 1;
   public static final int European = 2;
}
