/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.Positionable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Category<T>
implements Positionable {
    private String _name;
    private T _value;
    private CategoryRange<T> _range;

    public Category(String name, T value) {
        this.setName(name);
        this._value = value;
    }

    public Category(String name, T value, CategoryRange<T> range) {
        this.setName(name);
        this._value = value;
        this._range = range;
    }

    public Category(T value) {
        this._value = value;
    }

    public Category(T value, CategoryRange<T> range) {
        this._value = value;
        this._range = range;
    }

    public CategoryRange<T> getRange() {
        return this._range;
    }

    public void setRange(CategoryRange<T> range) {
        this._range = range;
    }

    @Override
    public double position() {
        if (this._range == null) {
            throw new IllegalStateException("Cannot compute position for a category that does not belong to a range");
        }
        return this._range.position(this._value);
    }

    public T getValue() {
        return this._value;
    }

    public String getName() {
        if (this._name == null) {
            return this._value.toString();
        }
        return this._name;
    }

    private void setName(String name) {
        this._name = name;
    }

    @Override
    public int compareTo(Positionable o) {
        double otherPosition = o.position();
        double position = this.position();
        if (position < otherPosition) {
            return -1;
        }
        if (position > otherPosition) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public String toString() {
        return String.format("#<Category name='%s' value='%s'>", this._name, this._value.toString());
    }
}

