/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCommitMediator;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCommitter;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNImportMediator;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNFileFilter;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitClient
extends SVNBasicClient {
    private ISVNCommitHandler myCommitHandler;
    private ISVNCommitParameters myCommitParameters;

    public SVNCommitClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNCommitClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setCommitHander(ISVNCommitHandler handler) {
        this.myCommitHandler = handler;
    }

    public void setCommitHandler(ISVNCommitHandler handler) {
        this.myCommitHandler = handler;
    }

    public ISVNCommitHandler getCommitHandler() {
        if (this.myCommitHandler == null) {
            this.myCommitHandler = new DefaultSVNCommitHandler();
        }
        return this.myCommitHandler;
    }

    public void setCommitParameters(ISVNCommitParameters parameters) {
        this.myCommitParameters = parameters;
    }

    public ISVNCommitParameters getCommitParameters() {
        if (this.myCommitParameters == null) {
            this.myCommitParameters = new DefaultSVNCommitParameters();
        }
        return this.myCommitParameters;
    }

    public SVNCommitInfo doDelete(SVNURL[] urls, String commitMessage) throws SVNException {
        return this.doDelete(urls, commitMessage, null);
    }

    public SVNCommitInfo doDelete(SVNURL[] urls, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        SVNCommitInfo info;
        if (urls == null || urls.length == 0) {
            return SVNCommitInfo.NULL;
        }
        ArrayList<String> paths = new ArrayList<String>();
        SVNURL rootURL = SVNURLUtil.condenceURLs(urls, paths, true);
        if (rootURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Can not compute common root URL for specified URLs");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (paths.isEmpty()) {
            paths.add(SVNPathUtil.tail(rootURL.getURIEncodedPath()));
            rootURL = rootURL.removePathTail();
        }
        SVNCommitItem[] commitItems = new SVNCommitItem[paths.size()];
        for (int i = 0; i < commitItems.length; ++i) {
            String path = (String)paths.get(i);
            commitItems[i] = new SVNCommitItem(null, rootURL.appendPath(path, true), null, SVNNodeKind.NONE, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, false, true, false, false, false, false);
        }
        commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, commitItems);
        if (commitMessage == null) {
            return SVNCommitInfo.NULL;
        }
        ArrayList<String> decodedPaths = new ArrayList<String>();
        for (String path : paths) {
            decodedPaths.add(SVNEncodingUtil.uriDecode(path));
        }
        paths = decodedPaths;
        SVNRepository repos = this.createRepository(rootURL, null, null, true);
        for (String path : paths) {
            SVNNodeKind kind = repos.checkPath(path, -1L);
            if (kind != SVNNodeKind.NONE) continue;
            SVNURL url = rootURL.appendPath(path, false);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "URL ''{0}'' does not exist", url);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        commitMessage = SVNCommitUtil.validateCommitMessage(commitMessage);
        SVNPropertiesManager.validateRevisionProperties(revisionProperties);
        ISVNEditor commitEditor = repos.getCommitEditor(commitMessage, null, false, revisionProperties, null);
        ISVNCommitPathHandler deleter = new ISVNCommitPathHandler(){

            public boolean handleCommitPath(String commitPath, ISVNEditor commitEditor) throws SVNException {
                commitEditor.deleteEntry(commitPath, -1L);
                return false;
            }
        };
        try {
            SVNCommitUtil.driveCommitEditor(deleter, paths, commitEditor, -1L);
            info = commitEditor.closeEdit();
        }
        catch (SVNException e) {
            try {
                commitEditor.abortEdit();
            }
            catch (SVNException inner) {
                // empty catch block
            }
            throw e;
        }
        if (info != null && info.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, info.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
        }
        return info != null ? info : SVNCommitInfo.NULL;
    }

    public SVNCommitInfo doMkDir(SVNURL[] urls, String commitMessage) throws SVNException {
        return this.doMkDir(urls, commitMessage, null, false);
    }

    public SVNCommitInfo doMkDir(SVNURL[] urls, String commitMessage, SVNProperties revisionProperties, boolean makeParents) throws SVNException {
        SVNCommitInfo info;
        if (makeParents) {
            LinkedList allURLs = new LinkedList();
            for (int i = 0; i < urls.length; ++i) {
                SVNURL url = urls[i];
                this.addURLParents(allURLs, url);
            }
            urls = allURLs.toArray(new SVNURL[allURLs.size()]);
        }
        if (urls == null || urls.length == 0) {
            return SVNCommitInfo.NULL;
        }
        AbstractCollection paths = new SVNHashSet();
        SVNURL rootURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (rootURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Can not compute common root URL for specified URLs");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (paths.isEmpty()) {
            paths.add(SVNPathUtil.tail(rootURL.getURIEncodedPath()));
            rootURL = rootURL.removePathTail();
        }
        if (paths.contains("")) {
            ArrayList<String> convertedPaths = new ArrayList<String>();
            String tail = SVNPathUtil.tail(rootURL.getURIEncodedPath());
            rootURL = rootURL.removePathTail();
            for (String path : paths) {
                if ("".equals(path)) {
                    convertedPaths.add(tail);
                    continue;
                }
                convertedPaths.add(SVNPathUtil.append(tail, path));
            }
            paths = convertedPaths;
        }
        ArrayList sortedPaths = new ArrayList(paths);
        Collections.sort(sortedPaths, SVNPathUtil.PATH_COMPARATOR);
        SVNCommitItem[] commitItems = new SVNCommitItem[sortedPaths.size()];
        for (int i = 0; i < commitItems.length; ++i) {
            String path;
            path = (String)sortedPaths.get(i);
            commitItems[i] = new SVNCommitItem(null, rootURL.appendPath(path, true), null, SVNNodeKind.DIR, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, true, false, false, false, false, false);
        }
        commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, commitItems);
        if (commitMessage == null) {
            return SVNCommitInfo.NULL;
        }
        ArrayList<String> decodedPaths = new ArrayList<String>();
        for (String path : sortedPaths) {
            decodedPaths.add(SVNEncodingUtil.uriDecode(path));
        }
        paths = decodedPaths;
        SVNRepository repos = this.createRepository(rootURL, null, null, true);
        commitMessage = SVNCommitUtil.validateCommitMessage(commitMessage);
        SVNPropertiesManager.validateRevisionProperties(revisionProperties);
        ISVNEditor commitEditor = repos.getCommitEditor(commitMessage, null, false, revisionProperties, null);
        ISVNCommitPathHandler creater = new ISVNCommitPathHandler(){

            public boolean handleCommitPath(String commitPath, ISVNEditor commitEditor) throws SVNException {
                SVNPathUtil.checkPathIsValid(commitPath);
                commitEditor.addDir(commitPath, null, -1L);
                return true;
            }
        };
        try {
            SVNCommitUtil.driveCommitEditor(creater, paths, commitEditor, -1L);
            info = commitEditor.closeEdit();
        }
        catch (SVNException e) {
            try {
                commitEditor.abortEdit();
            }
            catch (SVNException inner) {
                // empty catch block
            }
            throw e;
        }
        if (info != null && info.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, info.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
        }
        return info != null ? info : SVNCommitInfo.NULL;
    }

    public SVNCommitInfo doImport(File path, SVNURL dstURL, String commitMessage, boolean recursive) throws SVNException {
        return this.doImport(path, dstURL, commitMessage, null, true, false, SVNDepth.fromRecurse(recursive));
    }

    public SVNCommitInfo doImport(File path, SVNURL dstURL, String commitMessage, boolean useGlobalIgnores, boolean recursive) throws SVNException {
        return this.doImport(path, dstURL, commitMessage, null, useGlobalIgnores, false, SVNDepth.fromRecurse(recursive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo doImport(File path, SVNURL dstURL, String commitMessage, SVNProperties revisionProperties, boolean useGlobalIgnores, boolean ignoreUnknownNodeTypes, SVNDepth depth) throws SVNException {
        SVNErrorMessage err;
        SVNRepository repos = null;
        SVNFileType srcKind = SVNFileType.getType(path);
        if (srcKind == SVNFileType.NONE) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Path ''{0}'' does not exist", path);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        ArrayList<String> newPaths = new ArrayList<String>();
        SVNURL rootURL = dstURL;
        repos = this.createRepository(rootURL, null, null, true);
        SVNURL reposRoot = repos.getRepositoryRoot(true);
        while (!reposRoot.equals(rootURL) && repos.checkPath("", -1L) == SVNNodeKind.NONE) {
            newPaths.add(SVNPathUtil.tail(rootURL.getPath()));
            rootURL = rootURL.removePathTail();
            repos = this.createRepository(rootURL, null, null, true);
        }
        if (newPaths.isEmpty() && (srcKind == SVNFileType.FILE || srcKind == SVNFileType.SYMLINK)) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", dstURL);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (newPaths.contains(SVNFileUtil.getAdminDirectoryName())) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ADM_DIR_RESERVED, "''{0}'' is a reserved name and cannot be imported", SVNFileUtil.getAdminDirectoryName());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNCommitItem[] items = new SVNCommitItem[]{new SVNCommitItem(path, dstURL, null, srcKind == SVNFileType.DIRECTORY ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, true, false, false, false, false, false)};
        items[0].setPath(path.getName());
        commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, items);
        if (commitMessage == null) {
            return SVNCommitInfo.NULL;
        }
        commitMessage = SVNCommitUtil.validateCommitMessage(commitMessage);
        SVNPropertiesManager.validateRevisionProperties(revisionProperties);
        ISVNEditor commitEditor = repos.getCommitEditor(commitMessage, null, false, revisionProperties, new SVNImportMediator());
        String filePath = "";
        if (srcKind != SVNFileType.DIRECTORY) {
            filePath = (String)newPaths.remove(0);
            for (int i = 0; i < newPaths.size(); ++i) {
                String newDir = (String)newPaths.get(i);
                filePath = newDir + "/" + filePath;
            }
        }
        Collection ignores = useGlobalIgnores ? SVNStatusEditor.getGlobalIgnores(this.getOptions()) : null;
        this.checkCancelled();
        boolean changed = false;
        SVNCommitInfo info = null;
        try {
            commitEditor.openRoot(-1L);
            String newDirPath = null;
            for (int i = newPaths.size() - 1; i >= 0; --i) {
                newDirPath = newDirPath == null ? (String)newPaths.get(i) : SVNPathUtil.append(newDirPath, (String)newPaths.get(i));
                commitEditor.addDir(newDirPath, null, -1L);
            }
            changed = newPaths.size() > 0;
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            if (srcKind == SVNFileType.DIRECTORY) {
                changed |= this.importDir(deltaGenerator, path, newDirPath, useGlobalIgnores, ignoreUnknownNodeTypes, depth, commitEditor);
            } else if (srcKind == SVNFileType.FILE || srcKind == SVNFileType.SYMLINK) {
                if (!useGlobalIgnores || !SVNStatusEditor.isIgnored(ignores, path, "/" + path.getName())) {
                    changed |= this.importFile(deltaGenerator, path, srcKind, filePath, commitEditor);
                }
            } else if (srcKind == SVNFileType.NONE || srcKind == SVNFileType.UNKNOWN) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "''{0}'' does not exist", path);
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            if (!changed) {
                try {
                    commitEditor.abortEdit();
                }
                catch (SVNException e) {
                    // empty catch block
                }
                SVNCommitInfo e = SVNCommitInfo.NULL;
                return e;
            }
            for (int i = 0; i < newPaths.size(); ++i) {
                commitEditor.closeDir();
            }
            info = commitEditor.closeEdit();
        }
        finally {
            if (!changed || info == null) {
                try {
                    commitEditor.abortEdit();
                }
                catch (SVNException e) {}
            }
        }
        if (info != null && info.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, info.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
        }
        return info != null ? info : SVNCommitInfo.NULL;
    }

    public SVNCommitInfo doCommit(File[] paths, boolean keepLocks, String commitMessage, boolean force, boolean recursive) throws SVNException {
        return this.doCommit(paths, keepLocks, commitMessage, null, null, false, force, SVNDepth.getInfinityOrEmptyDepth(recursive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo doCommit(File[] paths, boolean keepLocks, String commitMessage, SVNProperties revisionProperties, String[] changelists, boolean keepChangelist, boolean force, SVNDepth depth) throws SVNException {
        SVNCommitPacket packet = this.doCollectCommitItems(paths, keepLocks, force, depth, changelists);
        try {
            packet = packet.removeSkippedItems();
            SVNCommitInfo sVNCommitInfo = this.doCommit(packet, keepLocks, keepChangelist, commitMessage, revisionProperties);
            return sVNCommitInfo;
        }
        finally {
            if (packet != null) {
                packet.dispose();
            }
        }
    }

    public SVNCommitInfo doCommit(SVNCommitPacket commitPacket, boolean keepLocks, String commitMessage) throws SVNException {
        return this.doCommit(commitPacket, keepLocks, false, commitMessage, null);
    }

    public SVNCommitInfo doCommit(SVNCommitPacket commitPacket, boolean keepLocks, boolean keepChangelist, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        SVNCommitInfo[] info = this.doCommit(new SVNCommitPacket[]{commitPacket}, keepLocks, keepChangelist, commitMessage, revisionProperties);
        if (info != null && info.length > 0) {
            if (info[0].getErrorMessage() != null && info[0].getErrorMessage().getErrorCode() != SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED) {
                SVNErrorManager.error(info[0].getErrorMessage(), SVNLogType.DEFAULT);
            }
            return info[0];
        }
        return SVNCommitInfo.NULL;
    }

    public SVNCommitInfo[] doCommit(SVNCommitPacket[] commitPackets, boolean keepLocks, String commitMessage) throws SVNException {
        return this.doCommit(commitPackets, keepLocks, false, commitMessage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo[] doCommit(SVNCommitPacket[] commitPackets, boolean keepLocks, boolean keepChangelist, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        if (commitPackets == null || commitPackets.length == 0) {
            return new SVNCommitInfo[0];
        }
        Collection tmpFiles = null;
        SVNCommitInfo info = null;
        ISVNEditor commitEditor = null;
        ArrayList<SVNCommitInfo> infos = new ArrayList<SVNCommitInfo>();
        boolean needsSleepForTimeStamp = false;
        for (int p = 0; p < commitPackets.length; ++p) {
            SVNCommitPacket commitPacket = commitPackets[p].removeSkippedItems();
            if (commitPacket.getCommitItems().length == 0) continue;
            try {
                SVNCommitItem item;
                commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, commitPacket.getCommitItems());
                if (commitMessage == null) {
                    infos.add(SVNCommitInfo.NULL);
                    continue;
                }
                commitMessage = SVNCommitUtil.validateCommitMessage(commitMessage);
                TreeMap commitables = new TreeMap();
                SVNURL baseURL = SVNCommitUtil.translateCommitables(commitPacket.getCommitItems(), commitables);
                Map lockTokens = SVNCommitUtil.translateLockTokens(commitPacket.getLockTokens(), baseURL.toString());
                SVNCommitItem firstItem = commitPacket.getCommitItems()[0];
                SVNRepository repository = this.createRepository(baseURL, firstItem.getFile(), firstItem.getWCAccess(), true);
                SVNCommitMediator mediator = new SVNCommitMediator(commitables);
                tmpFiles = mediator.getTmpFiles();
                String repositoryRoot = repository.getRepositoryRoot(true).getPath();
                SVNPropertiesManager.validateRevisionProperties(revisionProperties);
                commitEditor = repository.getCommitEditor(commitMessage, lockTokens, keepLocks, revisionProperties, mediator);
                for (int i = 0; i < commitPacket.getCommitItems().length; ++i) {
                    commitPacket.getCommitItems()[i].getWCAccess().setEventHandler(this.getEventDispatcher());
                }
                info = SVNCommitter.commit(mediator.getTmpFiles(), commitables, repositoryRoot, commitEditor);
                SVNHashSet processedItems = new SVNHashSet();
                SVNHashSet explicitCommitPaths = new SVNHashSet();
                for (String url : commitables.keySet()) {
                    item = (SVNCommitItem)commitables.get(url);
                    explicitCommitPaths.add(item.getPath());
                }
                for (String url : commitables.keySet()) {
                    SVNEntry entry;
                    String target;
                    SVNAdminArea dir;
                    String path;
                    SVNWCAccess wcAccess;
                    block36: {
                        item = (SVNCommitItem)commitables.get(url);
                        wcAccess = item.getWCAccess();
                        path = item.getPath();
                        dir = null;
                        target = null;
                        try {
                            if (item.getKind() == SVNNodeKind.DIR) {
                                target = "";
                                dir = wcAccess.retrieve(item.getFile());
                            } else {
                                target = SVNPathUtil.tail(path);
                                dir = wcAccess.retrieve(item.getFile().getParentFile());
                            }
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_LOCKED) break block36;
                            dir = null;
                        }
                    }
                    if (dir == null) {
                        if (SVNCommitClient.hasProcessedParents(processedItems, path)) {
                            processedItems.add(path);
                            continue;
                        }
                        if (item.isDeleted() && item.getKind() == SVNNodeKind.DIR) {
                            SVNEntry entryInParent;
                            SVNAdminArea parentDir;
                            String nameInParent;
                            File parentPath = "".equals(path) ? null : item.getFile().getParentFile();
                            String string = nameInParent = "".equals(path) ? null : SVNPathUtil.tail(path);
                            if (parentPath != null && (parentDir = wcAccess.retrieve(parentPath)) != null && (entryInParent = parentDir.getEntry(nameInParent, true)) != null) {
                                SVNHashMap attributes = new SVNHashMap();
                                attributes.put("svn:entry:schedule", null);
                                attributes.put("svn:entry:deleted", Boolean.TRUE.toString());
                                parentDir.modifyEntry(nameInParent, attributes, true, true);
                            }
                            processedItems.add(path);
                            continue;
                        }
                    }
                    if ((entry = dir.getEntry(target, true)) == null && SVNCommitClient.hasProcessedParents(processedItems, path)) {
                        processedItems.add(path);
                        continue;
                    }
                    boolean recurse = false;
                    if (item.isAdded() && item.getCopyFromURL() != null && item.getKind() == SVNNodeKind.DIR) {
                        recurse = true;
                    }
                    boolean removeLock = !keepLocks && item.isLocked();
                    SVNProperties wcPropChanges = mediator.getWCProperties(item);
                    dir.commit(target, info, wcPropChanges, removeLock, recurse, !keepChangelist, explicitCommitPaths, this.getCommitParameters());
                    processedItems.add(path);
                }
                needsSleepForTimeStamp = true;
                this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, info.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
            }
            catch (SVNException e) {
                if (e instanceof SVNCancelException) {
                    throw e;
                }
                SVNErrorMessage err = e.getErrorMessage().wrap("Commit failed (details follow):");
                infos.add(new SVNCommitInfo(-1L, null, null, err));
                this.dispatchEvent(SVNEventFactory.createErrorEvent(err, SVNEventAction.COMMIT_COMPLETED), -1.0);
                continue;
            }
            finally {
                if (info == null && commitEditor != null) {
                    try {
                        commitEditor.abortEdit();
                    }
                    catch (SVNException e) {}
                }
                if (tmpFiles != null) {
                    for (File file : tmpFiles) {
                        file.delete();
                    }
                }
                if (commitPacket != null) {
                    commitPacket.dispose();
                }
            }
            infos.add(info != null ? info : SVNCommitInfo.NULL);
        }
        if (needsSleepForTimeStamp) {
            this.sleepForTimeStamp();
        }
        return infos.toArray(new SVNCommitInfo[infos.size()]);
    }

    public SVNCommitPacket doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, boolean recursive) throws SVNException {
        SVNDepth depth = recursive ? SVNDepth.INFINITY : SVNDepth.EMPTY;
        return this.doCollectCommitItems(paths, keepLocks, force, depth, null);
    }

    public SVNCommitPacket doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, SVNDepth depth, String[] changelists) throws SVNException {
        SVNDepth sVNDepth = depth = depth == null ? SVNDepth.UNKNOWN : depth;
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        if (paths == null || paths.length == 0) {
            return SVNCommitPacket.EMPTY;
        }
        ArrayList targets = new ArrayList();
        SVNStatusClient statusClient = new SVNStatusClient(this.getRepositoryPool(), this.getOptions());
        statusClient.setEventHandler(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
            }

            public void checkCancelled() throws SVNCancelException {
                SVNCommitClient.this.checkCancelled();
            }
        });
        SVNWCAccess wcAccess = SVNCommitUtil.createCommitWCAccess(paths, depth, force, targets, statusClient);
        SVNAdminArea[] areas = wcAccess.getAdminAreas();
        for (int i = 0; areas != null && i < areas.length; ++i) {
            if (areas[i] == null) continue;
            areas[i].setCommitParameters(this.getCommitParameters());
        }
        try {
            SVNHashSet changelistsSet;
            SVNHashMap lockTokens = new SVNHashMap();
            this.checkCancelled();
            SVNHashSet sVNHashSet = changelistsSet = changelists != null ? new SVNHashSet() : null;
            if (changelists != null) {
                for (int j = 0; j < changelists.length; ++j) {
                    changelistsSet.add(changelists[j]);
                }
            }
            SVNCommitItem[] commitItems = SVNCommitUtil.harvestCommitables(wcAccess, targets, lockTokens, !keepLocks, depth, force, changelistsSet, this.getCommitParameters());
            boolean hasModifications = false;
            this.checkCancelled();
            for (int i = 0; commitItems != null && i < commitItems.length; ++i) {
                SVNCommitItem commitItem = commitItems[i];
                if (!commitItem.isAdded() && !commitItem.isDeleted() && !commitItem.isContentsModified() && !commitItem.isPropertiesModified() && !commitItem.isCopied()) continue;
                hasModifications = true;
                break;
            }
            if (!hasModifications) {
                wcAccess.close();
                return SVNCommitPacket.EMPTY;
            }
            return new SVNCommitPacket(wcAccess, commitItems, lockTokens);
        }
        catch (SVNException e) {
            wcAccess.close();
            if (e instanceof SVNCancelException) {
                throw e;
            }
            SVNErrorMessage nestedErr = e.getErrorMessage();
            SVNErrorMessage err = SVNErrorMessage.create(nestedErr.getErrorCode(), "Commit failed (details follow):");
            SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
            return null;
        }
    }

    public SVNCommitPacket[] doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, boolean recursive, boolean combinePackets) throws SVNException {
        SVNDepth depth = recursive ? SVNDepth.INFINITY : SVNDepth.EMPTY;
        return this.doCollectCommitItems(paths, keepLocks, force, depth, combinePackets, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitPacket[] doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, SVNDepth depth, boolean combinePackets, String[] changelists) throws SVNException {
        SVNDepth sVNDepth = depth = depth == null ? SVNDepth.UNKNOWN : depth;
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        if (paths == null || paths.length == 0) {
            return new SVNCommitPacket[0];
        }
        ArrayList<SVNCommitPacket> packets = new ArrayList<SVNCommitPacket>();
        SVNHashMap targets = new SVNHashMap();
        SVNStatusClient statusClient = new SVNStatusClient(this.getRepositoryPool(), this.getOptions());
        statusClient.setEventHandler(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
            }

            public void checkCancelled() throws SVNCancelException {
                SVNCommitClient.this.checkCancelled();
            }
        });
        SVNWCAccess[] wcAccesses = SVNCommitUtil.createCommitWCAccess2(paths, depth, force, targets, statusClient);
        for (int i = 0; i < wcAccesses.length; ++i) {
            SVNWCAccess wcAccess = wcAccesses[i];
            SVNAdminArea[] areas = wcAccess.getAdminAreas();
            for (int j = 0; areas != null && j < areas.length; ++j) {
                if (areas[j] == null) continue;
                areas[j].setCommitParameters(this.getCommitParameters());
            }
            Collection targetPaths = (Collection)targets.get(wcAccess);
            try {
                SVNHashSet changelistsSet;
                this.checkCancelled();
                SVNHashMap lockTokens = new SVNHashMap();
                SVNHashSet sVNHashSet = changelistsSet = changelists != null ? new SVNHashSet() : null;
                if (changelists != null) {
                    for (int j = 0; j < changelists.length; ++j) {
                        changelistsSet.add(changelists[j]);
                    }
                }
                SVNCommitItem[] commitItems = SVNCommitUtil.harvestCommitables(wcAccess, targetPaths, lockTokens, !keepLocks, depth, force, changelistsSet, this.getCommitParameters());
                this.checkCancelled();
                boolean hasModifications = false;
                for (int j = 0; commitItems != null && j < commitItems.length; ++j) {
                    SVNCommitItem commitItem = commitItems[j];
                    if (!commitItem.isAdded() && !commitItem.isDeleted() && !commitItem.isContentsModified() && !commitItem.isPropertiesModified() && !commitItem.isCopied()) continue;
                    hasModifications = true;
                    break;
                }
                if (!hasModifications) {
                    wcAccess.close();
                    continue;
                }
                packets.add(new SVNCommitPacket(wcAccess, commitItems, lockTokens));
                continue;
            }
            catch (SVNException e) {
                for (int j = 0; j < wcAccesses.length; ++j) {
                    wcAccesses[j].close();
                }
                if (e instanceof SVNCancelException) {
                    throw e;
                }
                SVNErrorMessage nestedErr = e.getErrorMessage();
                SVNErrorMessage err = SVNErrorMessage.create(nestedErr.getErrorCode(), "Commit failed (details follow):");
                SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
            }
        }
        SVNCommitPacket[] packetsArray = packets.toArray(new SVNCommitPacket[packets.size()]);
        if (!combinePackets) {
            return packetsArray;
        }
        SVNHashMap repoUUIDs = new SVNHashMap();
        SVNHashMap locktokensMap = new SVNHashMap();
        try {
            for (int i = 0; i < packetsArray.length; ++i) {
                this.checkCancelled();
                SVNCommitPacket packet = packetsArray[i];
                File wcRoot = SVNWCUtil.getWorkingCopyRoot(packet.getCommitItems()[0].getWCAccess().getAnchor(), true);
                SVNWCAccess rootWCAccess = this.createWCAccess();
                String uuid = null;
                SVNURL url = null;
                try {
                    SVNAdminArea rootDir = rootWCAccess.open(wcRoot, false, 0);
                    uuid = rootDir.getEntry(rootDir.getThisDirName(), false).getUUID();
                    url = rootDir.getEntry(rootDir.getThisDirName(), false).getSVNURL();
                }
                finally {
                    rootWCAccess.close();
                }
                this.checkCancelled();
                if (uuid == null) {
                    if (url != null) {
                        SVNRepository repos = this.createRepository(url, wcRoot, rootWCAccess, true);
                        uuid = repos.getRepositoryUUID(true);
                    } else {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", wcRoot);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                }
                if (!repoUUIDs.containsKey(uuid = uuid + url.getProtocol() + ":" + url.getHost() + ":" + url.getPort() + ":" + url.getUserInfo())) {
                    repoUUIDs.put(uuid, new ArrayList());
                    locktokensMap.put(uuid, new SVNHashMap());
                }
                Collection items = (Collection)repoUUIDs.get(uuid);
                Map lockTokens = (Map)locktokensMap.get(uuid);
                for (int j = 0; j < packet.getCommitItems().length; ++j) {
                    items.add(packet.getCommitItems()[j]);
                }
                if (packet.getLockTokens() != null) {
                    lockTokens.putAll(packet.getLockTokens());
                }
                this.checkCancelled();
            }
            packetsArray = new SVNCommitPacket[repoUUIDs.size()];
            int index = 0;
            Iterator roots = repoUUIDs.keySet().iterator();
            while (roots.hasNext()) {
                this.checkCancelled();
                String uuid = (String)roots.next();
                Collection items = (Collection)repoUUIDs.get(uuid);
                Map lockTokens = (Map)locktokensMap.get(uuid);
                SVNCommitItem[] itemsArray = items.toArray(new SVNCommitItem[items.size()]);
                packetsArray[index++] = new SVNCommitPacket(null, itemsArray, lockTokens);
            }
        }
        catch (SVNException e) {
            for (int j = 0; j < wcAccesses.length; ++j) {
                wcAccesses[j].close();
            }
            if (e instanceof SVNCancelException) {
                throw e;
            }
            SVNErrorMessage nestedErr = e.getErrorMessage();
            SVNErrorMessage err = SVNErrorMessage.create(nestedErr.getErrorCode(), "Commit failed (details follow):");
            SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
        }
        return packetsArray;
    }

    private void addURLParents(List targets, SVNURL url) throws SVNException {
        SVNURL parentURL = url.removePathTail();
        SVNRepository repos = this.createRepository(parentURL, null, null, true);
        SVNNodeKind kind = repos.checkPath("", -1L);
        if (kind == SVNNodeKind.NONE) {
            this.addURLParents(targets, parentURL);
        }
        targets.add(url);
    }

    private boolean importDir(SVNDeltaGenerator deltaGenerator, File dir, String importPath, boolean useGlobalIgnores, boolean ignoreUnknownNodeTypes, SVNDepth depth, ISVNEditor editor) throws SVNException {
        this.checkCancelled();
        File[] children = SVNFileListUtil.listFiles(dir);
        boolean changed = false;
        ISVNFileFilter filter = this.getCommitHandler() instanceof ISVNFileFilter ? (ISVNFileFilter)((Object)this.getCommitHandler()) : null;
        Collection ignores = useGlobalIgnores ? SVNStatusEditor.getGlobalIgnores(this.getOptions()) : null;
        for (int i = 0; children != null && i < children.length; ++i) {
            String path;
            File file = children[i];
            if (SVNFileUtil.getAdminDirectoryName().equals(file.getName())) {
                SVNEvent skippedEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.NONE, null, -1L, SVNEventAction.SKIP, SVNEventAction.COMMIT_ADDED, null, null);
                this.handleEvent(skippedEvent, -1.0);
                continue;
            }
            if (filter != null && !filter.accept(file)) continue;
            String string = path = importPath == null ? file.getName() : SVNPathUtil.append(importPath, file.getName());
            if (useGlobalIgnores && SVNStatusEditor.isIgnored(ignores, file, "/" + path)) continue;
            SVNFileType fileType = SVNFileType.getType(file);
            if (fileType == SVNFileType.DIRECTORY && depth.compareTo(SVNDepth.IMMEDIATES) >= 0) {
                editor.addDir(path, null, -1L);
                changed |= true;
                SVNEvent event = SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNEventAction.COMMIT_ADDED, null, null, null);
                this.handleEvent(event, -1.0);
                SVNDepth depthBelowHere = depth;
                if (depth == SVNDepth.IMMEDIATES) {
                    depthBelowHere = SVNDepth.EMPTY;
                }
                this.importDir(deltaGenerator, file, path, useGlobalIgnores, ignoreUnknownNodeTypes, depthBelowHere, editor);
                editor.closeDir();
                continue;
            }
            if ((fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) && depth.compareTo(SVNDepth.FILES) >= 0) {
                changed |= this.importFile(deltaGenerator, file, fileType, path, editor);
                continue;
            }
            if (fileType == SVNFileType.DIRECTORY || fileType == SVNFileType.FILE) continue;
            if (ignoreUnknownNodeTypes) {
                SVNEvent skippedEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.NONE, null, -1L, SVNEventAction.SKIP, SVNEventAction.COMMIT_ADDED, null, null);
                this.handleEvent(skippedEvent, -1.0);
                continue;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown or unversionable type for ''{0}''", file);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importFile(SVNDeltaGenerator deltaGenerator, File file, SVNFileType fileType, String filePath, ISVNEditor editor) throws SVNException {
        if (fileType == null || fileType == SVNFileType.UNKNOWN) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "unknown or unversionable type for ''{0}''", file);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        editor.addFile(filePath, null, -1L);
        Map autoProperties = new SVNHashMap();
        if (fileType != SVNFileType.SYMLINK) {
            autoProperties = SVNPropertiesManager.computeAutoProperties(this.getOptions(), file, autoProperties);
        } else {
            autoProperties.put("svn:special", "*");
        }
        String mimeTypeProperty = (String)autoProperties.get("svn:mime-type");
        for (String name : autoProperties.keySet()) {
            String value = (String)autoProperties.get(name);
            if ("svn:eol-style".equals(name) && value != null && (SVNProperty.isBinaryMimeType(mimeTypeProperty) || !SVNTranslator.checkNewLines(file))) continue;
            if ("svnkit:charset".equals(name) && value != null) {
                if (SVNProperty.isBinaryMimeType(mimeTypeProperty)) continue;
                try {
                    SVNTranslator.getCharset(value, mimeTypeProperty, filePath, this.getOptions());
                }
                catch (SVNException e) {
                    continue;
                }
            }
            editor.changeFileProperty(filePath, name, SVNPropertyValue.create(value));
        }
        SVNEvent addedEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, mimeTypeProperty, -1L, SVNEventAction.COMMIT_ADDED, null, null, null);
        this.handleEvent(addedEvent, -1.0);
        String charset = SVNTranslator.getCharset((String)autoProperties.get("svnkit:charset"), mimeTypeProperty, file.getPath(), this.getOptions());
        String eolStyle = (String)autoProperties.get("svn:eol-style");
        String keywords = (String)autoProperties.get("svn:keywords");
        boolean special = autoProperties.get("svn:special") != null;
        File tmpFile = null;
        if (charset != null || eolStyle != null || keywords != null || special) {
            byte[] eolBytes = SVNTranslator.getBaseEOL(eolStyle);
            Map keywordsMap = keywords != null ? SVNTranslator.computeKeywords(keywords, null, null, null, null, this.getOptions()) : null;
            tmpFile = SVNFileUtil.createTempFile("import", ".tmp");
            SVNTranslator.translate(file, tmpFile, charset, eolBytes, keywordsMap, special, false);
        }
        File importedFile = tmpFile != null ? tmpFile : file;
        InputStream is = null;
        String checksum = null;
        try {
            is = SVNFileUtil.openFileForReading(importedFile, SVNLogType.WC);
            editor.applyTextDelta(filePath, null);
            checksum = deltaGenerator.sendDelta(filePath, is, editor, true);
        }
        finally {
            SVNFileUtil.closeFile(is);
            SVNFileUtil.deleteFile(tmpFile);
        }
        editor.closeFile(filePath, checksum);
        return true;
    }

    private static boolean hasProcessedParents(Collection paths, String path) throws SVNException {
        if (paths.contains(path = SVNPathUtil.removeTail(path))) {
            return true;
        }
        if ("".equals(path)) {
            return false;
        }
        return SVNCommitClient.hasProcessedParents(paths, path);
    }

    static String validateCommitMessage(String message) {
        if (message == null) {
            return message;
        }
        message = message.replaceAll("\r\n", "\n");
        message = message.replace('\r', '\n');
        return message;
    }
}

