/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config;

import com.ice.config.ConfigureSpec;
import com.ice.pref.PrefsTupleTable;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public abstract class ConfigureEditor
extends JPanel {
    protected UserPrefs prefs = null;
    protected ConfigureSpec spec = null;
    protected boolean helpIsShowing = false;
    protected JPanel helpPanel = null;
    protected JTextArea helpText = null;
    protected JButton helpButton = null;
    protected JPanel editPanel = null;
    protected JScrollPane editScroller = null;
    protected JPanel editorPanel = null;
    protected JPanel descPan = null;
    protected JTextArea descText = null;
    protected int descOffset = 25;

    public abstract void saveChanges(UserPrefs var1, ConfigureSpec var2);

    public abstract void requestInitialFocus();

    protected abstract JPanel createEditPanel();

    public ConfigureEditor(String type) {
        this.establishContents(type);
    }

    public void edit(UserPrefs prefs, ConfigureSpec spec) {
        String help = spec.getHelp();
        String desc = spec.getDescription();
        if (this.helpIsShowing) {
            this.toggleHelp();
        }
        if (desc != null && desc.length() > 0) {
            this.descText.setText(desc);
            this.descPan.setVisible(true);
        } else {
            this.descPan.setVisible(false);
        }
        this.descPan.revalidate();
        if (help != null && help.length() > 0) {
            this.helpButton.setEnabled(true);
            this.helpText.setText(help);
            this.helpText.revalidate();
        } else {
            this.helpButton.setEnabled(false);
            this.helpText.setText("No Help Available.");
        }
        this.helpPanel.revalidate();
    }

    public void commit(ConfigureSpec spec, UserPrefs prefs, UserPrefs orig) {
        if (this.isModified(spec, prefs, orig)) {
            this.commitChanges(spec, prefs, orig);
        }
    }

    public void commitChanges(ConfigureSpec spec, UserPrefs prefs, UserPrefs orig) {
        String propName = spec.getPropertyName();
        if (this.isStringArray(spec)) {
            String[] strAry = prefs.getStringArray(propName, null);
            orig.removeStringArray(propName);
            if (strAry != null) {
                orig.setStringArray(propName, strAry);
            }
        } else if (this.isTupleTable(spec)) {
            PrefsTupleTable table = prefs.getTupleTable(propName, null);
            orig.removeTupleTable(propName);
            if (table != null) {
                orig.setTupleTable(propName, table);
            }
        } else {
            String value = prefs.getProperty(propName);
            orig.setProperty(propName, value);
        }
    }

    public boolean isTupleTable(ConfigureSpec spec) {
        return spec.isTupleTable();
    }

    public boolean isStringArray(ConfigureSpec spec) {
        return spec.isStringArray();
    }

    public boolean isModified(ConfigureSpec spec, UserPrefs prefs, UserPrefs orig) {
        String propName = spec.getPropertyName();
        if (this.isTupleTable(spec)) {
            PrefsTupleTable nt = prefs.getTupleTable(propName, null);
            PrefsTupleTable ot = orig.getTupleTable(propName, null);
            if (nt != null && ot != null ? !nt.equals(ot) : nt != null || ot != null) {
                return true;
            }
        } else if (this.isStringArray(spec)) {
            String[] na = prefs.getStringArray(propName, null);
            String[] oa = orig.getStringArray(propName, null);
            if (na != null && oa != null) {
                if (na.length != oa.length) {
                    return true;
                }
                int i = 0;
                while (i < na.length) {
                    if (!na[i].equals(oa[i])) {
                        return true;
                    }
                    ++i;
                }
            } else if (na != null || oa != null) {
                return true;
            }
        } else {
            String ns = prefs.getProperty(propName);
            String os = orig.getProperty(propName);
            if (ns != null && os != null ? !ns.equals(os) : ns != null || os != null) {
                return true;
            }
        }
        return false;
    }

    protected String getHelpButtonToolTipText() {
        return "Show Help Text";
    }

    protected JPanel establishHelpPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.setBorder(new EmptyBorder(5, 3, 3, 3));
        this.helpText = new JTextArea();
        this.helpText.setEnabled(false);
        this.helpText.setEditable(false);
        this.helpText.setDisabledTextColor(Color.black);
        this.helpText.setLineWrap(true);
        this.helpText.setWrapStyleWord(true);
        this.helpText.setOpaque(false);
        this.helpText.setMargin(new Insets(2, 4, 2, 4));
        result.add("Center", this.helpText);
        return result;
    }

    private void toggleHelp() {
        if (this.helpIsShowing) {
            this.editScroller.getViewport().remove(this.helpPanel);
            this.editScroller.getViewport().setView(this.editPanel);
            this.editScroller.revalidate();
        } else {
            this.editScroller.getViewport().remove(this.editPanel);
            this.editScroller.getViewport().setView(this.helpPanel);
            this.editScroller.revalidate();
        }
        this.repaint(50L);
        this.helpIsShowing = !this.helpIsShowing;
    }

    private JPanel establishEditPanel(String type) {
        boolean col = false;
        int row = 0;
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        this.editorPanel = this.createEditPanel();
        AWTUtilities.constrain(result, this.editorPanel, 1, 10, 0, row++, 1, 1, 1.0, 1.0);
        this.descText = new JTextArea("");
        this.descText.setEnabled(false);
        this.descText.setEditable(false);
        this.descText.setDisabledTextColor(Color.black);
        this.descText.setLineWrap(true);
        this.descText.setWrapStyleWord(true);
        this.descText.setOpaque(false);
        this.descPan = new JPanel();
        this.descPan.setLayout(new BorderLayout());
        this.descPan.add("Center", this.descText);
        this.descPan.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(0), "Description"), new EmptyBorder(10, 15, 15, 15)));
        AWTUtilities.constrain(result, this.descPan, 1, 15, 0, row++, 1, 1, 1.0, 1.0, new Insets(this.descOffset, 5, 5, 5));
        JPanel fillerPan = new JPanel();
        AWTUtilities.constrain(result, fillerPan, 1, 15, 0, row++, 1, 1, 1.0, 1.0);
        return result;
    }

    private void establishContents(String type) {
        this.setLayout(new BorderLayout());
        JPanel typePan = new JPanel();
        typePan.setLayout(new GridBagLayout());
        JLabel lbl = new JLabel(type);
        lbl.setBorder(new EmptyBorder(3, 3, 5, 3));
        AWTUtilities.constrain(typePan, lbl, 2, 17, 0, 0, 1, 1, 1.0, 0.0);
        try {
            Image iHelp = AWTUtilities.getImageResource("/com/ice/config/images/icons/confighelp.gif");
            ImageIcon helpIcon = new ImageIcon(iHelp);
            this.helpButton = new JButton((Icon)helpIcon){

                public boolean isFocusTraversable() {
                    return false;
                }
            };
            this.helpButton.setMargin(new Insets(1, 3, 1, 3));
        }
        catch (IOException ex) {
            this.helpButton = new JButton("?");
        }
        this.helpButton.setToolTipText(this.getHelpButtonToolTipText());
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigureEditor.this.toggleHelp();
            }
        });
        AWTUtilities.constrain(typePan, this.helpButton, 0, 13, 1, 0, 1, 1, 0.0, 0.0);
        this.helpPanel = this.establishHelpPanel();
        this.editPanel = this.establishEditPanel(type);
        this.editScroller = new JScrollPane(this.editPanel);
        this.add("Center", this.editScroller);
        this.add("North", typePan);
    }
}

