/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config.editor;

import com.ice.config.ConfigureEditor;
import com.ice.config.ConfigureSpec;
import com.ice.pref.UserPrefs;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ConfigComboEditor
extends ConfigureEditor {
    protected JPanel comboPanel;
    protected JComboBox combo;

    public ConfigComboEditor() {
        super("Combo");
    }

    public void edit(UserPrefs prefs, ConfigureSpec spec) {
        super.edit(prefs, spec);
        this.comboPanel.removeAll();
        String propName = spec.getPropertyName();
        String choice = prefs.getProperty(propName, null);
        String[] choices = spec.getChoices();
        this.combo = new JComboBox<String>(choices);
        this.comboPanel.add(this.combo);
        if (choice != null) {
            this.combo.setSelectedItem(choice);
        }
        this.comboPanel.validate();
        this.comboPanel.repaint(250L);
    }

    public void saveChanges(UserPrefs prefs, ConfigureSpec spec) {
        String propName = spec.getPropertyName();
        String oldChoice = prefs.getProperty(propName, null);
        String newChoice = (String)this.combo.getSelectedItem();
        prefs.setProperty(propName, newChoice);
    }

    public void requestInitialFocus() {
    }

    protected JPanel createEditPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        result.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.comboPanel = result;
        return this.comboPanel;
    }
}

