/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config.editor;

import com.ice.config.ConfigureEditor;
import com.ice.config.ConfigureSpec;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public abstract class ConfigNumberEditor
extends ConfigureEditor {
    protected JTextField numField;

    public ConfigNumberEditor(String typeTitle) {
        super(typeTitle);
    }

    public abstract String getTypeTitle();

    public abstract String formatNumber(UserPrefs var1, ConfigureSpec var2);

    public abstract boolean isChanged(UserPrefs var1, ConfigureSpec var2, String var3);

    public void edit(UserPrefs prefs, ConfigureSpec spec) {
        super.edit(prefs, spec);
        this.numField.setText(this.formatNumber(prefs, spec));
    }

    public void saveChanges(UserPrefs prefs, ConfigureSpec spec) {
        String numText = this.numField.getText();
        if (this.isChanged(prefs, spec, numText)) {
            prefs.setProperty(spec.getPropertyName(), numText);
        }
    }

    public void requestInitialFocus() {
        this.numField.requestFocus();
        this.numField.selectAll();
    }

    protected JPanel createEditPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new EmptyBorder(5, 3, 3, 3));
        int col = 0;
        int row = 0;
        JLabel lbl = new JLabel("Value");
        lbl.setBorder(new EmptyBorder(1, 3, 1, 3));
        AWTUtilities.constrain(result, lbl, 0, 17, col++, row, 1, 1, 0.0, 0.0);
        this.numField = new JTextField("0");
        AWTUtilities.constrain(result, this.numField, 2, 17, col++, row, 1, 1, 1.0, 0.0);
        return result;
    }
}

