/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config.editor;

import com.ice.config.ConfigureSpec;
import com.ice.config.editor.ConfigArrayEditor;
import com.ice.pref.UserPrefs;
import java.util.Vector;

public class ConfigStringArrayEditor
extends ConfigArrayEditor {
    public ConfigStringArrayEditor() {
        super("String Array");
    }

    public boolean isTupleTable(ConfigureSpec spec) {
        return false;
    }

    public boolean isStringArray(ConfigureSpec spec) {
        return true;
    }

    public void edit(UserPrefs prefs, ConfigureSpec spec) {
        super.edit(prefs, spec);
        Vector v = prefs.getStringVector(spec.getPropertyName(), null);
        if (v != null) {
            this.model.setData(v);
        } else {
            this.model.setData(new Vector());
        }
        this.table.sizeColumnsToFit(-1);
        this.table.repaint(100L);
    }

    public void saveChanges(UserPrefs prefs, ConfigureSpec spec) {
        this.table.clearSelection();
        Vector vStrs = this.model.getData();
        Object[] strs = new String[vStrs.size()];
        vStrs.copyInto(strs);
        prefs.setStringArray(spec.getPropertyName(), (String[])strs);
    }

    public void commitChanges(ConfigureSpec spec, UserPrefs prefs, UserPrefs orig) {
        String propName = spec.getPropertyName();
        String[] strs = prefs.getStringArray(propName, null);
        orig.removeStringArray(propName);
        if (strs != null) {
            orig.setStringArray(propName, strs);
        }
    }
}

