/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import com.ice.cvsc.CVSLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CVSIgnore {
    public static final String RCS_ID = "$Id: CVSIgnore.java,v 2.4 2003/07/27 01:08:32 time Exp $";
    public static final String RCS_REV = "$Revision: 2.4 $";
    private static final String DEFAULT_IGNORE_SPEC = "RCSLOG RCS SCCS CVS cvslog.*tags TAGS *~ #* ,**.old *.bak *.orig *.rej .del-**.a *.o *.elc *.ln core*.zip *.tar *.gz *.z *.Z";
    private Vector specs = null;

    public CVSIgnore() {
        this.setIgnoreSpec(DEFAULT_IGNORE_SPEC);
    }

    public CVSIgnore(String default_spec) {
        this.setIgnoreSpec(default_spec);
    }

    public int size() {
        return this.specs.size();
    }

    public void addIgnoreSpec(String spec) {
        if (spec == null) {
            return;
        }
        if (this.specs == null) {
            this.specs = new Vector();
        }
        StringTokenizer toker = new StringTokenizer(spec);
        int count = toker.countTokens();
        int i = 0;
        while (i < count) {
            String toke;
            try {
                toke = toker.nextToken();
            }
            catch (NoSuchElementException ex) {
                break;
            }
            if (toke.equals("!")) {
                this.specs = new Vector();
            } else {
                this.specs.addElement(toke);
            }
            ++i;
        }
    }

    public void addIgnoreFile(File ignoreFile) {
        block9: {
            if (ignoreFile == null) {
                return;
            }
            boolean ok = true;
            BufferedReader in = null;
            if (this.specs == null) {
                this.specs = new Vector();
            }
            try {
                in = new BufferedReader(new FileReader(ignoreFile));
            }
            catch (IOException ex) {
                in = null;
                ok = false;
            }
            while (ok) {
                String line;
                try {
                    line = in.readLine();
                }
                catch (IOException ex) {
                    line = null;
                }
                if (line == null) break;
                this.addIgnoreSpec(line);
            }
            if (in == null) break block9;
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
    }

    public void setIgnoreSpec(String spec) {
        if (this.specs != null) {
            this.specs.removeAllElements();
        }
        this.addIgnoreSpec(spec);
    }

    public boolean isFileToBeIgnored(String name) {
        int i = 0;
        while (i < this.specs.size()) {
            String spec = (String)this.specs.elementAt(i);
            if (this.fileMatchesExpr(name, spec)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean fileMatchesExpr(String fileName, String matchExpr) {
        return this.matchExprRecursor(fileName, matchExpr, 0, 0);
    }

    /*
     * Unable to fully structure code
     */
    private boolean matchExprRecursor(String string, String pattern, int sIdx, int pIdx) {
        pLen = pattern.length();
        sLen = string.length();
        while (true) {
            block16: {
                if (pIdx >= pLen) {
                    return sIdx >= sLen;
                }
                if (sIdx >= sLen && pattern.charAt(pIdx) != '*') {
                    return false;
                }
                if (pattern.charAt(pIdx) == '*') {
                    if (++pIdx >= pLen) {
                        return true;
                    }
                    while (true) {
                        if (this.matchExprRecursor(string, pattern, sIdx, pIdx)) {
                            return true;
                        }
                        if (sIdx >= sLen) {
                            return false;
                        }
                        ++sIdx;
                    }
                }
                if (pattern.charAt(pIdx) == '?') {
                    ++pIdx;
                    ++sIdx;
                    continue;
                }
                if (pattern.charAt(pIdx) != '[') break block16;
                ++pIdx;
                while (true) {
                    block17: {
                        if (pIdx >= pLen || pattern.charAt(pIdx) == ']') {
                            return false;
                        }
                        if (pattern.charAt(pIdx) == string.charAt(sIdx)) ** GOTO lbl43
                        if (pIdx >= pLen - 1 || pattern.charAt(pIdx + 1) != '-') break block17;
                        if (pIdx >= pLen - 2) {
                            return false;
                        }
                        chStr = string.charAt(sIdx);
                        chPtn = pattern.charAt(pIdx);
                        chPtn2 = pattern.charAt(pIdx + 2);
                        if (chPtn <= chStr && chPtn2 >= chStr || chPtn >= chStr && chPtn2 <= chStr) ** GOTO lbl43
                        pIdx += 2;
                    }
                    ++pIdx;
                }
lbl-1000:
                // 1 sources

                {
                    if (pIdx >= pLen) {
                        --pIdx;
                        break;
                    }
                    ++pIdx;
lbl43:
                    // 3 sources

                    ** while (pattern.charAt((int)pIdx) != ']')
                }
lbl44:
                // 2 sources

                ++pIdx;
                ++sIdx;
                continue;
            }
            if (pattern.charAt(pIdx) == '\\' && ++pIdx >= pLen) {
                return false;
            }
            if (pIdx < pLen && sIdx < sLen && pattern.charAt(pIdx) != string.charAt(sIdx)) {
                return false;
            }
            ++pIdx;
            ++sIdx;
        }
    }

    public void dumpIgnoreList(String message) {
        if (message != null) {
            CVSLog.logMsg(message);
        }
        int i = 0;
        while (i < this.specs.size()) {
            String spec = (String)this.specs.elementAt(i);
            CVSLog.logMsg("Ignore[" + i + "] '" + spec + "'");
            ++i;
        }
    }
}

