/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class CVSLog {
    private static final String RCS_ID = "$Id: CVSLog.java,v 2.7 2003/07/27 01:08:32 time Exp $";
    private static final String RCS_REV = "$Revision: 2.7 $";
    private static final String RCS_NAME = "$Name:  $";
    public static final String DEFAULT_FILENAME = "cvslog.txt";
    public static boolean debug;
    public static boolean debugOpen;
    private static String filename;
    private static FileWriter file;
    private static PrintWriter stream;
    private static boolean checked;
    private static boolean open;
    private static boolean echo;
    private static boolean autoFlush;

    public static void setLogFilename(String filename) {
        CVSLog.filename = filename;
        checked = false;
    }

    public static void setAutoFlush(boolean autoflush) {
    }

    public static void checkLogOpen() {
        if (checked) {
            return;
        }
        checked = true;
        if (!open && filename != null) {
            CVSLog.openLogFile();
        }
    }

    public static void openLogFile() {
        boolean isok = true;
        if (debugOpen) {
            new Throwable("OPEN CVS LOG").printStackTrace();
        }
        if (debug) {
            System.err.println("CVSLog.openLogFile( " + filename + " )");
        }
        if (filename == null) {
            return;
        }
        try {
            file = new FileWriter(filename);
        }
        catch (Exception ex) {
            CVSLog.logMsg("error opening log file '" + filename + "', trying 'user.dir' - " + ex.getMessage());
            String userDirStr = System.getProperty("user.dir", "");
            filename = userDirStr + File.separator + DEFAULT_FILENAME;
            try {
                file = new FileWriter(filename);
            }
            catch (Exception ex2) {
                CVSLog.logMsg("error opening log file '" + filename + "' - " + ex2.getMessage());
                file = null;
                isok = false;
            }
        }
        if (isok) {
            stream = new PrintWriter(file);
            open = true;
        }
        echo = false;
    }

    public static void closeLog() {
        if (open) {
            open = false;
            if (stream != null) {
                stream.flush();
                stream.close();
            }
        }
        checked = false;
    }

    public static void setEcho(boolean setting) {
        echo = setting;
    }

    public static void traceMsg(Throwable thrown, String msg) {
        CVSLog.logMsg(msg);
        CVSLog.logMsg(thrown.getMessage());
        if (!open) {
            thrown.printStackTrace(System.err);
        } else {
            thrown.printStackTrace(stream);
        }
        if (autoFlush && open) {
            stream.flush();
        }
    }

    public static void logMsg(String msg) {
        CVSLog.checkLogOpen();
        if (open) {
            stream.println(msg);
            if (autoFlush && open) {
                stream.flush();
            }
        }
        if (echo) {
            System.out.println(msg);
        }
    }

    public static void logMsgStdout(String msg) {
        CVSLog.checkLogOpen();
        if (open) {
            stream.println(msg);
            if (autoFlush && open) {
                stream.flush();
            }
        }
        System.out.println(msg);
    }

    public static void logMsgStderr(String msg) {
        CVSLog.checkLogOpen();
        if (open) {
            stream.println(msg);
            if (autoFlush && open) {
                stream.flush();
            }
        }
        System.err.println(msg);
    }

    static {
        open = false;
        checked = false;
        autoFlush = true;
        debug = false;
        debugOpen = false;
        filename = new String(DEFAULT_FILENAME);
    }
}

