/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.config.ConfigurePanel;
import com.ice.config.DefaultConfigureEditorFactory;
import com.ice.jcvsii.ExecCommandEditor;
import com.ice.jcvsii.LookAndFeelEditor;
import com.ice.jcvsii.ResourceMgr;
import com.ice.jcvsii.ServerCommandEditor;
import com.ice.pref.UserPrefs;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class ConfigDialog
extends JDialog
implements ActionListener {
    public static final String RCS_ID = "$Id: ConfigDialog.java,v 1.4 2000/06/11 00:18:53 time Exp $";
    public static final String RCS_REV = "$Revision: 1.4 $";
    private boolean okClicked = false;
    private ConfigurePanel configPan;

    public ConfigDialog(Frame parent, String title, UserPrefs prefs, UserPrefs specs) {
        super(parent, title, true);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        DefaultConfigureEditorFactory factory = new DefaultConfigureEditorFactory(specs);
        factory.addEditor("cmdexec", new ExecCommandEditor());
        factory.addEditor("srvrcmd", new ServerCommandEditor());
        factory.addEditor("plafcls", new LookAndFeelEditor());
        this.configPan = new ConfigurePanel(prefs, specs, factory);
        content.add("Center", this.configPan);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 2));
        ResourceMgr rmgr = ResourceMgr.getInstance();
        JButton okBtn = new JButton(rmgr.getUIString("name.for.save"));
        okBtn.addActionListener(this);
        okBtn.setActionCommand("SAVE");
        buttons.add(this.buttonPanel(okBtn));
        JButton canBtn = new JButton(rmgr.getUIString("name.for.cancel"));
        canBtn.addActionListener(this);
        canBtn.setActionCommand("CANCEL");
        buttons.add(this.buttonPanel(canBtn));
        JPanel butPan = new JPanel();
        butPan.setLayout(new BorderLayout());
        butPan.add("East", buttons);
        JPanel southPan = new JPanel();
        southPan.setLayout(new BorderLayout());
        southPan.add("North", new JSeparator(0));
        southPan.add("Center", butPan);
        content.add("South", southPan);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                ConfigDialog.this.configPan.setDividerLocation(0.3);
            }
        });
    }

    private JPanel buttonPanel(JButton button) {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.setLayout(new BorderLayout());
        panel.add("Center", button);
        return panel;
    }

    public void editProperty(String prop) {
        this.configPan.editProperty(prop);
    }

    public void editProperties(String[] props) {
        this.configPan.editProperties(props);
    }

    public void editPath(String path) {
        this.configPan.editPath(path);
    }

    public void editPaths(String[] paths) {
        this.configPan.editPaths(paths);
    }

    public void actionPerformed(ActionEvent event) {
        boolean doExit = false;
        String command = event.getActionCommand();
        if (command.equals("SAVE")) {
            doExit = true;
            this.okClicked = true;
            this.configPan.saveCurrentEdit();
            this.configPan.commit();
        } else if (command.equals("CANCEL")) {
            doExit = true;
        }
        if (doExit) {
            this.dispose();
        }
    }

    public boolean getOKClicked() {
        return this.okClicked;
    }
}

