/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSArgumentVector;
import com.ice.cvsc.CVSClient;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSProject;
import com.ice.cvsc.CVSRequest;
import com.ice.cvsc.CVSResponse;
import com.ice.cvsc.CVSScramble;
import com.ice.cvsc.CVSUserInterface;
import com.ice.jcvsii.CVSThread;
import com.ice.jcvsii.CVSUtilities;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.ConnectInfoPanel;
import com.ice.jcvsii.MainPanel;
import com.ice.jcvsii.MainTabPanel;
import com.ice.jcvsii.ResourceMgr;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ExportPanel
extends MainTabPanel
implements ActionListener,
CVSUserInterface {
    protected CVSClient client;
    protected ConnectInfoPanel info;
    protected JTextField argumentsText;
    protected JTextArea outputText;
    protected JLabel feedback;
    protected JButton actionButton;

    public ExportPanel(MainPanel parent) {
        super(parent);
        this.establishContents();
    }

    public void loadPreferences() {
        this.info.loadPreferences("export");
    }

    public void savePreferences() {
        this.info.savePreferences("export");
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equalsIgnoreCase("EXPORT")) {
            this.performExport();
        } else if (command.equalsIgnoreCase("CANCEL")) {
            this.cancelExport();
        }
    }

    private void cancelExport() {
        this.client.setCanceled(true);
    }

    private void performExport() {
        Config cfg = Config.getInstance();
        UserPrefs prefs = cfg.getPreferences();
        ResourceMgr rmgr = ResourceMgr.getInstance();
        Point location = this.getLocationOnScreen();
        String argumentStr = this.info.getArguments();
        CVSEntryVector entries = new CVSEntryVector();
        CVSArgumentVector arguments = CVSArgumentVector.parseArgumentString(argumentStr);
        String userName = this.info.getUserName();
        String passWord = this.info.getPassword();
        String hostname = this.info.getServer();
        String repository = this.info.getModule();
        String rootDirectory = this.info.getRepository();
        String exportDirectory = this.info.getExportDirectory();
        boolean isPServer = this.info.isPServer();
        int connMethod = this.info.getConnectionMethod();
        int cvsPort = CVSUtilities.computePortNum(hostname, connMethod, isPServer);
        if (arguments.size() < 2 || !arguments.containsArgument("-r") && !arguments.containsArgument("-D")) {
            String msg = rmgr.getUIString("export.needs.option.msg");
            String title = rmgr.getUIString("export.needs.option.title");
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg, title, 0);
            return;
        }
        if (hostname.length() < 1 || repository.length() < 1 || rootDirectory.length() < 1 || exportDirectory.length() < 1) {
            Object[] fmtArgs = new String[]{hostname.length() < 1 ? rmgr.getUIString("name.for.cvsserver") : (repository.length() < 1 ? rmgr.getUIString("name.for.cvsmodule") : (rootDirectory.length() < 1 ? rmgr.getUIString("name.for.cvsrepos") : rmgr.getUIString("name.for.exportdir")))};
            String msg = rmgr.getUIFormat("export.needs.input.msg", fmtArgs);
            String title = rmgr.getUIString("export.needs.input.title");
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg, title, 0);
            return;
        }
        if (userName.length() < 1 && (connMethod == 2 || connMethod == 3)) {
            String msg = rmgr.getUIString("common.rsh.needs.user.msg");
            String title = rmgr.getUIString("common.rsh.needs.user.title");
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg, title, 0);
            return;
        }
        File localRootDir = new File(exportDirectory);
        if (!localRootDir.exists()) {
            Object[] fmtArgs = new String[]{localRootDir.getPath()};
            String prompt = rmgr.getUIFormat("export.create.directory.prompt", fmtArgs);
            String title = rmgr.getUIString("export.create.directory.title");
            if (JOptionPane.showConfirmDialog((Frame)this.getTopLevelAncestor(), prompt, title, 0) == 1) {
                return;
            }
            if (!localRootDir.mkdirs()) {
                Object[] failArgs = new String[]{localRootDir.getPath()};
                String msg = rmgr.getUIFormat("export.create.directory.failed.msg", failArgs);
                title = rmgr.getUIString("export.create.directory.failed.title");
                JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg, title, 0);
                return;
            }
        }
        this.getMainPanel().setAllTabsEnabled(false);
        this.client = CVSUtilities.createCVSClient(hostname, cvsPort);
        CVSProject project = new CVSProject(this.client);
        project.setUserName(userName);
        project.setTempDirectory(cfg.getTemporaryDirectory());
        project.setRepository(repository);
        project.setRootDirectory(rootDirectory);
        project.setLocalRootDirectory(exportDirectory);
        project.setPServer(isPServer);
        project.setConnectionPort(cvsPort);
        project.setConnectionMethod(connMethod);
        if (connMethod == 2) {
            CVSUtilities.establishRSHProcess(project);
        }
        project.setSetVariables(CVSUtilities.getUserSetVariables(hostname));
        project.setServerCommand(CVSUtilities.establishServerCommand(hostname, connMethod, isPServer));
        project.setAllowsGzipFileMode(prefs.getBoolean("global.allowGzipFileMode", false));
        project.setGzipStreamLevel(prefs.getInteger("global.gzipStreamLevel", 0));
        if (isPServer) {
            String scrambled = CVSScramble.scramblePassword(passWord, 'A');
            project.setPassword(scrambled);
        } else if (connMethod == 3) {
            project.setPassword(passWord);
        }
        project.establishRootEntry(rootDirectory);
        CVSRequest request = new CVSRequest();
        request.setPServer(isPServer);
        request.setUserName(userName);
        if (isPServer || connMethod == 3) {
            request.setPassword(project.getPassword());
        }
        request.setConnectionMethod(connMethod);
        request.setServerCommand(project.getServerCommand());
        request.setRshProcess(project.getRshProcess());
        request.setPort(cvsPort);
        request.setHostName(this.client.getHostName());
        request.setRepository(repository);
        request.setRootDirectory(rootDirectory);
        request.setRootRepository(rootDirectory);
        request.setLocalDirectory(localRootDir.getPath());
        request.setSetVariables(project.getSetVariables());
        request.setCommand("export");
        request.sendModule = false;
        request.sendArguments = true;
        request.handleUpdated = true;
        request.allowOverWrites = true;
        request.queueResponse = false;
        request.responseHandler = project;
        request.includeNotifies = false;
        request.traceRequest = CVSProject.overTraceRequest;
        request.traceResponse = CVSProject.overTraceResponse;
        request.traceTCPData = CVSProject.overTraceTCP;
        request.traceProcessing = CVSProject.overTraceProcessing;
        request.allowGzipFileMode = project.allowsGzipFileMode();
        request.setGzipStreamLevel(project.getGzipStreamLevel());
        request.setEntries(entries);
        arguments.appendArgument(repository);
        request.appendArguments(arguments);
        request.setUserInterface(this);
        CVSResponse response = new CVSResponse();
        ExportPanel exportPanel = this;
        exportPanel.getClass();
        MyRunner myRunner = exportPanel.new MyRunner(project, this.client, request, response);
        ExportPanel exportPanel2 = this;
        exportPanel2.getClass();
        CVSThread thread = new CVSThread("Export", (Runnable)myRunner, exportPanel2.new MyMonitor(request, response));
        thread.start();
    }

    public void uiDisplayProgressMsg(String message) {
        this.feedback.setText(message);
        this.feedback.repaint(0L);
    }

    public void uiDisplayProgramError(String error) {
    }

    public void uiDisplayResponse(CVSResponse response) {
    }

    private void establishContents() {
        this.setLayout(new GridBagLayout());
        this.info = new ConnectInfoPanel("export");
        this.info.setPServerMode(true);
        this.info.setUsePassword(true);
        int row = 0;
        AWTUtilities.constrain(this, this.info, 2, 17, 0, row++, 1, 1, 1.0, 0.0);
        this.actionButton = new JButton(ResourceMgr.getInstance().getUIString("export.perform.label"));
        this.actionButton.setActionCommand("EXPORT");
        this.actionButton.addActionListener(this);
        AWTUtilities.constrain(this, this.actionButton, 0, 10, 0, row++, 1, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        this.feedback = new JLabel(ResourceMgr.getInstance().getUIString("name.for.ready"));
        this.feedback.setOpaque(true);
        this.feedback.setBackground(Color.white);
        this.feedback.setBorder(new CompoundBorder(new LineBorder(Color.darkGray), new EmptyBorder(1, 3, 1, 3)));
        AWTUtilities.constrain(this, this.feedback, 2, 10, 0, row++, 1, 1, 1.0, 0.0, new Insets(4, 0, 3, 0));
        this.outputText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.outputText.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.outputText);
        scroller.setVerticalScrollBarPolicy(22);
        AWTUtilities.constrain(this, scroller, 1, 10, 0, row++, 1, 1, 1.0, 1.0);
    }

    private class MyMonitor
    implements CVSThread.Monitor {
        private CVSRequest request;
        private CVSResponse response;

        public MyMonitor(CVSRequest request, CVSResponse response) {
            this.request = request;
            this.response = response;
        }

        public void threadStarted() {
            ExportPanel.this.actionButton.setText(ResourceMgr.getInstance().getUIString("export.cancel.label"));
            ExportPanel.this.actionButton.setActionCommand("CANCEL");
        }

        public void threadCanceled() {
        }

        public void threadFinished() {
            ExportPanel.this.actionButton.setText(ResourceMgr.getInstance().getUIString("export.perform.label"));
            ExportPanel.this.actionButton.setActionCommand("EXPORT");
            String resultStr = this.response.getDisplayResults();
            if (this.response.getStatus() == 0) {
                ExportPanel.this.uiDisplayProgressMsg(ResourceMgr.getInstance().getUIString("export.status.success"));
            } else {
                ExportPanel.this.uiDisplayProgressMsg(ResourceMgr.getInstance().getUIString("export.status.failure"));
            }
            ExportPanel.this.outputText.setText(resultStr);
            ExportPanel.this.outputText.revalidate();
            ExportPanel.this.outputText.repaint();
            if (this.response != null && !this.request.saveTempFiles) {
                this.response.deleteTempFiles();
            }
            ExportPanel.this.getMainPanel().setAllTabsEnabled(true);
        }
    }

    private class MyRunner
    implements Runnable {
        private CVSClient client;
        private CVSProject project;
        private CVSRequest request;
        private CVSResponse response;

        public MyRunner(CVSProject project, CVSClient client, CVSRequest request, CVSResponse response) {
            this.client = client;
            this.project = project;
            this.request = request;
            this.response = response;
        }

        public void run() {
            this.client.processCVSRequest(this.request, this.response);
            this.project.processCVSResponse(this.request, this.response);
            if (this.request.getArguments().containsArgument("-P") || this.request.getArguments().containsArgument("-r") || this.request.getArguments().containsArgument("-D")) {
                this.project.pruneEmptySubDirs(false);
            }
        }
    }
}

