/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.util.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class JCVSSplash
extends JWindow
implements KeyListener,
MouseListener,
ActionListener {
    protected JPanel mainPan = null;
    protected JProgressBar progress = null;
    protected BoundedRangeModel progressModel = null;

    public JCVSSplash(String title, BoundedRangeModel progressModel) {
        this.progressModel = progressModel;
        Image img = null;
        try {
            img = AWTUtilities.getImageResource("/com/ice/jcvsii/images/splash.gif");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Dimension sz = new Dimension(480, 360);
        JLabel lbl = new JLabel("jCVS II");
        if (img != null) {
            this.prepareImage(img, this);
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(img, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException ex) {
                System.err.println("JCVSSplash: media tracker interrupted!\n   " + ex.getMessage());
            }
            sz.width = img.getWidth(this) + 80;
            sz.height = img.getHeight(this) + 80;
            ImageIcon icon = new ImageIcon(img);
            lbl = new JLabel(icon);
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - sz.width) / 2;
        int y = (screen.height - sz.height) / 3;
        this.setBounds(x, y, sz.width, sz.height);
        Container content = this.getContentPane();
        this.mainPan = new JPanel();
        this.mainPan.setLayout(new BorderLayout());
        this.mainPan.setBorder(new CompoundBorder(new BevelBorder(0), new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new BevelBorder(1))));
        content.setLayout(new BorderLayout());
        content.add("Center", this.mainPan);
        this.mainPan.add("Center", lbl);
        lbl.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(1), new EmptyBorder(5, 5, 5, 5))));
        if (progressModel != null) {
            this.progress = new JProgressBar(progressModel);
            JPanel pan = new JPanel();
            pan.setBorder(new EmptyBorder(2, 5, 5, 5));
            pan.setLayout(new BorderLayout());
            pan.add("Center", this.progress);
            this.mainPan.add("South", pan);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JCVSSplash.this.dispose();
                System.exit(0);
            }

            public void windowClosed(WindowEvent e) {
            }
        });
    }

    public synchronized void enableDismissEvents() {
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        this.dispose();
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        if (this.progressModel != null) {
            this.progressModel.setValue(this.progressModel.getMaximum());
            this.progress.repaint();
        }
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.dispose();
    }

    public static void main(String[] args) {
        DefaultBoundedRangeModel model = new DefaultBoundedRangeModel(0, 0, 0, 100);
        JCVSSplash splash = new JCVSSplash("jCVS II", model);
        splash.show();
        splash.requestFocus();
        splash.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
        JCVSSplash jCVSSplash = splash;
        jCVSSplash.getClass();
        jCVSSplash.new Progressor(splash, model).start();
    }

    private class Progressor
    extends Thread {
        JCVSSplash splash;
        BoundedRangeModel model;

        public Progressor(JCVSSplash s, BoundedRangeModel m) {
            super("Model");
            this.splash = s;
            this.model = m;
        }

        public void run() {
            try {
                Progressor.sleep(100L);
            }
            catch (InterruptedException ex) {}
            while (this.model.getValue() < this.model.getMaximum()) {
                this.model.setValue(this.model.getValue() + 10);
                try {
                    Progressor.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            this.model.setValue(this.model.getMaximum());
            this.splash.enableDismissEvents();
            try {
                Progressor.sleep(8000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.splash.dispose();
        }
    }
}

