/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import com.ice.util.ExecException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Exec
extends Thread {
    private String[] argv;
    private String[] envp;
    private StringBuffer results;
    private BufferedReader errRdr;
    private BufferedReader outRdr;
    private Process proc;
    private String lnSep;

    public Exec(StringBuffer resultBuf, String[] argv, String[] envp) {
        this.argv = argv;
        this.envp = envp;
        this.results = resultBuf;
        this.lnSep = System.getProperty("line.separator", "\n");
    }

    public void exec() throws ExecException {
        try {
            this.proc = Runtime.getRuntime().exec(this.argv, this.envp);
            this.start();
            try {
                this.join();
            }
            catch (InterruptedException ex) {
                this.appendEx(ex, "joining exec stdout thread");
            }
            try {
                this.proc.waitFor();
            }
            catch (InterruptedException ex) {
                this.appendEx(ex, "waiting for exec process");
            }
            int exitVal = this.proc.exitValue();
            if (this.results != null) {
                this.append("& Exit status = '" + exitVal + "'.");
            }
            if (exitVal != 0) {
                throw new ExecException("non-zero exist status", exitVal);
            }
        }
        catch (IOException ex) {
            throw new ExecException("IO exception exec-ing '" + this.argv[0] + "', " + ex.getMessage(), -1);
        }
    }

    public void run() {
        try {
            this.proc.getOutputStream().close();
            this.errRdr = new BufferedReader(new InputStreamReader(this.proc.getErrorStream()));
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        String ln;
                        while ((ln = Exec.this.errRdr.readLine()) != null) {
                            Exec.this.append(". " + ln);
                        }
                        Exec.this.errRdr.close();
                    }
                    catch (IOException ex) {
                        Exec.this.appendEx(ex, "reading exec stderr stream");
                    }
                }
            });
            t.start();
            this.outRdr = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
            while (this.results != null) {
                String ln = this.outRdr.readLine();
                if (ln == null) break;
                this.append("o " + ln);
            }
            this.outRdr.close();
            try {
                t.join();
            }
            catch (InterruptedException ex) {
                this.appendEx(ex, "joining exec stderr thread");
            }
        }
        catch (IOException ex) {
            this.appendEx(ex, "reading exec stdout stream");
        }
    }

    private void append(String str) {
        if (this.results != null) {
            this.results.append(str + this.lnSep);
        }
    }

    private void appendEx(Exception ex, String msg) {
        if (this.results != null) {
            StringWriter sW = new StringWriter();
            PrintWriter pW = new PrintWriter(sW);
            ex.printStackTrace(pW);
            this.results.append("* " + msg + this.lnSep);
            this.results.append(sW.toString());
        }
    }

    public void dump() {
        System.err.println("EXEC PARAMETERS:");
        int i = 0;
        while (i < this.argv.length) {
            System.err.println("   ARGS[" + i + "] '" + this.argv[i] + "'");
            ++i;
        }
        int i2 = 0;
        while (i2 < this.envp.length) {
            System.err.println("   ENVP[" + i2 + "] '" + this.envp[i2] + "'");
            ++i2;
        }
    }

    public void debugExec(StringBuffer buf) {
        buf.append("EXEC PARAMETERS: ----------------------" + this.lnSep);
        int i = 0;
        while (i < this.argv.length) {
            buf.append("   ARGS[" + i + "] '" + this.argv[i] + "'" + this.lnSep);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.envp.length) {
            buf.append("   ENVP[" + i2 + "] '" + this.envp[i2] + "'" + this.lnSep);
            ++i2;
        }
    }
}

