/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TempFileManager {
    private static int tempDocCounter = 0;
    private static String temnpDirName = null;
    private static String tempFilePrefix = null;
    private static String tempFileSuffix = null;
    private static Vector tempFiles = new Vector();

    public static void initialize(String dirName, String prefix, String suffix) {
        temnpDirName = dirName;
        tempFilePrefix = prefix;
        tempFileSuffix = suffix;
    }

    public static void setTemporaryDirectory(String dirName) {
        temnpDirName = dirName;
    }

    public static void setFilenamePrefix(String prefix) {
        tempFilePrefix = prefix;
    }

    public static void setFilenameSuffix(String suffix) {
        tempFileSuffix = suffix;
    }

    public static void addTemporaryFile(String filename) {
        tempFiles.addElement(filename);
    }

    public static String getTemporaryDirectory() {
        return temnpDirName;
    }

    public static String getTemporaryFilename() {
        ++tempDocCounter;
        return TempFileManager.getTemporaryFilename(tempFileSuffix);
    }

    public static String getTemporaryFilename(String suffix) {
        String tempFileName = temnpDirName + File.separator + tempFilePrefix + "-" + ++tempDocCounter + suffix;
        return tempFileName;
    }

    public static void clearTemporaryFiles() {
        int count = 0;
        int numFiles = tempFiles.size();
        int idx = 0;
        while (idx < numFiles) {
            String fileName = (String)tempFiles.elementAt(idx);
            File f = new File(fileName);
            if (f.exists() && f.isFile()) {
                f.delete();
                ++count;
            }
            ++idx;
        }
        System.err.println("Deleted " + count + " temporary documents.");
    }

    public static void writeTemporaryFile(InputStream source, String tempFileName) throws IOException {
        int cnt;
        FileOutputStream out = new FileOutputStream(tempFileName);
        byte[] buf = new byte[32768];
        while ((cnt = source.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, cnt);
        }
        out.close();
        TempFileManager.addTemporaryFile(tempFileName);
    }
}

