/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelState;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SocketChannel
extends Channel {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$connection$SocketChannel == null ? (class$com$sshtools$j2ssh$connection$SocketChannel = SocketChannel.class$("com.sshtools.j2ssh.connection.SocketChannel")) : class$com$sshtools$j2ssh$connection$SocketChannel));
    protected Socket socket = null;
    Thread thread;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$SocketChannel;

    public void bindSocket(Socket socket) throws IOException {
        if (this.state.getValue() != 1) {
            throw new IOException("The socket can only be bound to an unitialized channel");
        }
        this.socket = socket;
    }

    protected void onChannelData(SshMsgChannelData sshMsgChannelData) throws IOException {
        try {
            this.socket.getOutputStream().write(sshMsgChannelData.getChannelData());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void onChannelEOF() throws IOException {
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException iOException) {
            log.info((Object)("Failed to shutdown Socket OutputStream in response to EOF event: " + iOException.getMessage()));
        }
    }

    protected void onChannelClose() throws IOException {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            log.info((Object)("Failed to close socket on channel close event: " + iOException.getMessage()));
        }
    }

    protected void onChannelOpen() throws IOException {
        if (this.socket == null) {
            throw new IOException("The socket must be bound to the channel before opening");
        }
        this.thread = new Thread(new SocketReader());
        this.thread.start();
    }

    protected void onChannelExtData(SshMsgChannelExtendedData sshMsgChannelExtendedData) throws IOException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SocketReader
    implements Runnable {
        SocketReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] byArray = new byte[SocketChannel.this.getMaximumPacketSize()];
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            try {
                SocketChannel.this.socket.setSoTimeout(2000);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            try {
                int n = 0;
                while (n >= 0 && !SocketChannel.this.isClosed()) {
                    try {
                        n = SocketChannel.this.socket.getInputStream().read(byArray);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        n = interruptedIOException.bytesTransferred;
                    }
                    ChannelState channelState = SocketChannel.this.state;
                    synchronized (channelState) {
                        if (SocketChannel.this.isClosed() || SocketChannel.this.isLocalEOF()) {
                            break;
                        }
                        if (n > 0) {
                            byteArrayWriter.write(byArray, 0, n);
                            SocketChannel.this.sendChannelData(byteArrayWriter.toByteArray());
                            byteArrayWriter.reset();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                ChannelState channelState = SocketChannel.this.state;
                synchronized (channelState) {
                    if (!SocketChannel.this.isLocalEOF()) {
                        SocketChannel.this.setLocalEOF();
                    }
                    if (SocketChannel.this.isOpen()) {
                        SocketChannel.this.close();
                    }
                }
            }
            catch (Exception exception) {
                log.info((Object)("Failed to send channel EOF message: " + exception.getMessage()));
            }
            SocketChannel.this.thread = null;
        }
    }
}

