/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.Option;
import com.sshtools.common.ui.OptionCallback;
import com.sshtools.common.ui.OptionsDialog;
import com.sshtools.common.ui.SessionManager;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsConnectionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplicationSessionPanel
extends SshToolsApplicationPanel {
    public static final String PREF_CONNECTION_FILE_DIRECTORY = "sshapps.connectionFile.directory";
    protected Log log = LogFactory.getLog((Class)(class$com$sshtools$common$ui$SshToolsApplicationSessionPanel == null ? (class$com$sshtools$common$ui$SshToolsApplicationSessionPanel = SshToolsApplicationSessionPanel.class$("com.sshtools.common.ui.SshToolsApplicationSessionPanel")) : class$com$sshtools$common$ui$SshToolsApplicationSessionPanel));
    protected SshToolsConnectionProfile currentConnectionProfile;
    protected SessionManager manager;
    static /* synthetic */ Class class$com$sshtools$common$ui$SshToolsApplicationSessionPanel;

    public SshToolsApplicationSessionPanel() {
    }

    public SshToolsApplicationSessionPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public abstract SshToolsConnectionTab[] getAdditionalConnectionTabs();

    public abstract void addEventListener(ChannelEventListener var1);

    public abstract boolean requiresConfiguration();

    public abstract String getId();

    public final boolean openSession(SessionManager sessionManager, SshToolsConnectionProfile sshToolsConnectionProfile) throws IOException {
        this.manager = sessionManager;
        this.setCurrentConnectionProfile(sshToolsConnectionProfile);
        if (this.requiresConfiguration() && !sshToolsConnectionProfile.getApplicationPropertyBoolean(this.getId() + ".configured", false) && !this.editSettings(sshToolsConnectionProfile)) {
            return false;
        }
        return this.onOpenSession();
    }

    public abstract boolean onOpenSession() throws IOException;

    public boolean isConnected() {
        return this.manager != null && this.manager.isConnected();
    }

    public void setContainerTitle(File file) {
        String string = "";
        if (this.application != null) {
            string = ConfigurationLoader.getVersionString((String)this.application.getApplicationName(), (String)this.application.getApplicationVersion());
        }
        if (this.container != null) {
            this.container.setContainerTitle(file == null ? string : string + " [" + file.getName() + "]");
        }
    }

    public void setCurrentConnectionProfile(SshToolsConnectionProfile sshToolsConnectionProfile) {
        this.currentConnectionProfile = sshToolsConnectionProfile;
    }

    public SshToolsConnectionProfile getCurrentConnectionProfile() {
        return this.currentConnectionProfile;
    }

    public boolean editSettings(SshToolsConnectionProfile sshToolsConnectionProfile) {
        final SshToolsConnectionPanel sshToolsConnectionPanel = new SshToolsConnectionPanel(false);
        SshToolsConnectionTab[] sshToolsConnectionTabArray = this.getAdditionalConnectionTabs();
        int n = 0;
        while (sshToolsConnectionTabArray != null && n < sshToolsConnectionTabArray.length) {
            sshToolsConnectionTabArray[n].setConnectionProfile(sshToolsConnectionProfile);
            sshToolsConnectionPanel.addTab(sshToolsConnectionTabArray[n]);
            ++n;
        }
        sshToolsConnectionPanel.setConnectionProfile(sshToolsConnectionProfile);
        final Option option = new Option("Ok", "Apply the settings and close this dialog", 111);
        Option option2 = new Option("Cancel", "Close this dialog without applying the settings", 99);
        OptionCallback optionCallback = new OptionCallback(){

            public boolean canClose(OptionsDialog optionsDialog, Option option2) {
                if (option2 == option) {
                    return sshToolsConnectionPanel.validateTabs();
                }
                return true;
            }
        };
        OptionsDialog optionsDialog = OptionsDialog.createOptionDialog(this, new Option[]{option, option2}, sshToolsConnectionPanel, "Connection Settings", option, optionCallback, null);
        optionsDialog.pack();
        UIUtil.positionComponent(0, optionsDialog);
        optionsDialog.setVisible(true);
        if (optionsDialog.getSelectedOption() == option) {
            sshToolsConnectionPanel.applyTabs();
            this.manager.applyProfileChanges(sshToolsConnectionProfile);
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MenuItemActionComparator
    implements Comparator {
        MenuItemActionComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = ((Integer)((StandardAction)object).getValue("menuItemGroup")).compareTo((Integer)((StandardAction)object2).getValue("menuItemGroup"));
            return n == 0 ? ((Integer)((StandardAction)object).getValue("menuItemWeight")).compareTo((Integer)((StandardAction)object2).getValue("menuItemWeight")) : n;
        }
    }

    class ToolBarActionComparator
    implements Comparator {
        ToolBarActionComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = ((Integer)((StandardAction)object).getValue("toolBarGroup")).compareTo((Integer)((StandardAction)object2).getValue("toolBarGroup"));
            return n == 0 ? ((Integer)((StandardAction)object).getValue("toolBarWeight")).compareTo((Integer)((StandardAction)object2).getValue("toolBarWeight")) : n;
        }
    }
}

