/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcearcade.jinvaders;

import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HighScores {
    protected static final int MAX_ENTRIES = 10;
    protected static final String SEPARATOR = "#";
    protected ArrayList<String> highScores = new ArrayList();

    protected abstract boolean loadScores();

    protected abstract void saveScores(String var1, int var2);

    public Object[] getHighScores() {
        return this.highScores.toArray();
    }

    public int getHighScore() {
        return this.highScores != null && this.highScores.size() > 0 ? Integer.parseInt(this.highScores.get(1)) : 0;
    }

    protected String serializeScores(ArrayList<String> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append(arrayList.get(i));
            stringBuffer.append(SEPARATOR);
        }
        return stringBuffer.toString();
    }

    protected boolean deserializeScores(String string) {
        if (string != null) {
            this.highScores.clear();
            StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
            for (int i = 0; stringTokenizer.hasMoreTokens() && i < 20; ++i) {
                try {
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    Integer.parseInt(string3);
                    this.highScores.add(string2.toUpperCase());
                    this.highScores.add(string3);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Highscore data corrupted");
                    this.highScores.clear();
                }
            }
            return true;
        }
        return false;
    }

    public void postHighScore(String string, int n) {
        if (n <= 0) {
            return;
        }
        if (this.highScores.size() == 0) {
            this.highScores.add(string);
            this.highScores.add("" + n);
            this.saveScores(string, n);
        } else {
            try {
                boolean bl = false;
                for (int i = 1; i < this.highScores.size() && !bl; i += 2) {
                    int n2 = Integer.parseInt(this.highScores.get(i));
                    if (n > n2) {
                        this.highScores.add(i - 1, string);
                        this.highScores.add(i, "" + n);
                        bl = true;
                        continue;
                    }
                    if (n != n2) continue;
                    this.highScores.set(i - 1, string);
                    this.highScores.set(i, "" + n);
                    bl = true;
                }
                if (!bl) {
                    this.highScores.add(string);
                    this.highScores.add("" + n);
                }
                while (this.highScores.size() > 20) {
                    this.highScores.remove(this.highScores.size() - 1);
                }
                this.saveScores(string, n);
            }
            catch (Exception exception) {
                System.err.println("postHighScore: Error parsing scores");
            }
        }
    }
}

