/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Core.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.util.Random;
import Enemy;
import Enemies;

class Core extends EnemyKind implements EnemyDefines, GlobalDefines
{

/******************************** GLOBAL DATA ********************************/

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Core
 * DESCRIPTION	  :
 *****************************************************************************/
  Core()
  {

    score    = 200;
    hitsize  =	 4 << JKobo.Context.getScaleLog2();
    chipposx =	 0;
    chipposy =	 0;
    chipsize =	 0;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : make
 * DESCRIPTION	  :
 *****************************************************************************/
  void make(Enemy e)
  {

    e.count = 0;
    e.shield = 1;
    e.b = JKobo.Context.getEnemies().getEnemy2Interval() - 1;
    e.a = JKobo.Context.getRandom().nextInt() & e.b;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : move
 * DESCRIPTION	  :
 *****************************************************************************/
  void move(Enemy e)
  {
    int shift, ek;

    e.count++;
    e.count &= e.b;
    if(e.count == e.a &&
       e.norm < ((JKobo.Context.getScaleParms().getWindowWidth() +
		  JKobo.Context.getScaleParms().getSpriteWidth()) >> 1))
      {
	ek = JKobo.Context.getEnemies().getEnemyKindToGenerate2();
	shift = (ek == BEAM) ? 6 : 5;
	e.shotTemplate(ek, shift, 0, 0);
      }

  }

}  /* END OF CLASS : Core */


/* END OF FILE : Core.java */

