/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Pipe1.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.util.Random;

import Enemy;
import Enemies;
import Space;


class Pipe1 extends EnemyKind implements EnemyDefines, GlobalDefines, MapDefines
{

/******************************** GLOBAL DATA ********************************/

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Pipe1
 * DESCRIPTION	  :
 *****************************************************************************/
  Pipe1()
  {

    score    = 0;
    hitsize  = -1;
    chipposx = 0;
    chipposy = 0;
    chipsize = 0;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : make
 * DESCRIPTION	  :
 *****************************************************************************/
  void make(Enemy e)
  {

    e.shield = -1;
    e.count = 4;
    e.a = 0;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : move
 * DESCRIPTION	  :
 *****************************************************************************/
  void move(Enemy e)
  {
    int x1, y1, a_next, x_next, y_next;
    int p, wsize, shift, scrx, scry;
    int spr_size, spr_shift;
    Enemies enemies;
    Space space;
    ScaleParms sp;


    enemies = JKobo.Context.getEnemies();
    space = JKobo.Context.getSpace();
    sp = JKobo.Context.getScaleParms();
    wsize = sp.getWindowWidth();
    scrx = sp.getSpaceWidth();
    scry = sp.getSpaceHeight();
    shift = sp.getEnemyShift();
    spr_size = sp.getSpriteWidth();
    spr_shift = sp.getSpriteWidthShift();
    x1 = JKobo.Context.getRandom().nextInt();
    y1 = JKobo.Context.getRandom().nextInt();
    if((e.norm < ((wsize >>> 1) + (spr_size << 1))) && (e.count == 1))
	enemies.make(EXPLOSION, (e.x >> shift) + (x1 >>> 28) - 8,
		     (e.y >> shift) + (y1 >>> 28) - 8, 0, 0, 0);
    if(++e.count < 4)
      return;
    e.count = 0;
    x1 = ((e.x >> shift) & (scrx - 1)) >>> spr_shift;
    y1 = ((e.y >> shift) & (scry - 1)) >>> spr_shift;
    a_next = 0;
    x_next = 0;
    y_next = 0;
    p = space.getChipNumber(x1, y1);
    if(p == 0)
      {
	e.state = NOTUSE;
	return;
      }
    if(e.norm < ((wsize >>> 1) + (spr_size << 1)))
      enemies.make(EXPLOSION, e.x >> shift, e.y >> shift, 0, 0, 0);
    if((p^e.a) == U_MASK)
      {
	a_next = D_MASK;
	y_next = -(spr_size << shift);
      }
    if((p^e.a) == R_MASK)
      {
	a_next = L_MASK;
	x_next = (spr_size << shift);
      }
    if((p^e.a) == D_MASK)
      {
	a_next = U_MASK;
	y_next = (spr_size << shift);
      }
    if((p^e.a) == L_MASK)
      {
	a_next = R_MASK;
	x_next = -(spr_size << shift);
      }
    if(a_next != 0)
      {
	space.setChipNumber(x1, y1, 0);
	e.x += x_next;
	e.y += y_next;
	e.a  = a_next;
	return;
      }
    if(p != CORE)
      {
	p ^= e.a;
	space.setChipNumber(x1, y1, p);
      }
    e.state = NOTUSE;

  }

}  /* END OF CLASS : Pipe1 */


/* END OF FILE : Pipe1.java */

