/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.players;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.ac.nii.icpc2010.players.AbstractPlayer;
import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.IPlayField;

public class BasePlayer
extends AbstractPlayer {
    public BasePlayer(int id, IPlayField playField) {
        super(id, playField);
    }

    public ArrayList<Integer> getEnemyIds() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < this.playField.getNumOfPlayers()) {
            if (i != this.getId()) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    public boolean isFree(int x, int y) {
        int chip = 0;
        try {
            chip = this.playField.getObjectAt(x, y);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return chip == 0;
    }

    public boolean isCoin(int x, int y) {
        int chip = 0;
        try {
            chip = this.playField.getObjectAt(x, y);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return chip == 2;
    }

    public boolean isWall(int x, int y) {
        int chip = 0;
        try {
            chip = this.playField.getObjectAt(x, y);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return chip == 1;
    }

    public boolean isMyTron(int x, int y) {
        int chip = 0;
        try {
            chip = this.playField.getObjectAt(x, y);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return chip == this.getTrailId();
    }

    public boolean isEnemyTron(int x, int y) {
        int chip = 0;
        try {
            chip = this.playField.getObjectAt(x, y);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        for (int enemyId : this.getEnemyIds()) {
            if (chip != this.getTrailIdOf(enemyId)) continue;
            return true;
        }
        return false;
    }

    public boolean isTron(int x, int y) {
        return this.isMyTron(x, y) || this.isEnemyTron(x, y);
    }

    public boolean isSafe(int x, int y) {
        return this.isFree(x, y) || this.isCoin(x, y);
    }

    public int[] getPositionById(int id) {
        return new int[]{this.getXOf(id), this.getYOf(id)};
    }

    public Point getPosition(int id) {
        return new Point(this.getXOf(id), this.getYOf(id));
    }

    public FieldDirection[] getDirs() {
        return FieldDirection.values();
    }

    public List<FieldDirection> getRandomDirs() {
        ArrayList<FieldDirection> result = new ArrayList<FieldDirection>();
        FieldDirection[] fieldDirectionArray = this.getDirs();
        int n = fieldDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDirection fd = fieldDirectionArray[n2];
            result.add(fd);
            ++n2;
        }
        Collections.shuffle(result);
        return result;
    }

    public List<FieldDirection> getSafeDirs(int x, int y) {
        ArrayList<FieldDirection> result = new ArrayList<FieldDirection>();
        FieldDirection[] fieldDirectionArray = this.getDirs();
        int n = fieldDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDirection dir = fieldDirectionArray[n2];
            int[] pred = this.getPlayField().stepOne(x, y, dir);
            if (this.isSafe(pred[0], pred[1])) {
                result.add(dir);
            }
            ++n2;
        }
        return result;
    }

    public List<int[]> getAdjacentPos(int x, int y) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        FieldDirection[] fieldDirectionArray = this.getDirs();
        int n = fieldDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDirection dir = fieldDirectionArray[n2];
            result.add(this.getPlayField().stepOne(x, y, dir));
            ++n2;
        }
        return result;
    }

    @Override
    public FieldDirection getInput() {
        return FieldDirection.Up;
    }
}

