/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.recorder;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import jp.ac.nii.icpc2010.TronException;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.recorder.AbstractRecorder;

public class FileRecorder
extends AbstractRecorder {
    private String _fileName;

    public FileRecorder(String[] playerNames, String fileName, OptionsManager om) {
        super(playerNames, om);
        this._fileName = fileName;
    }

    @Override
    public void closeWriting() throws TronException {
        super.closeWriting();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(this._fileName));
            if (!this.om.isTournamentMode()) {
                System.out.println("writing to " + this._fileName);
            }
            oos.writeObject(this.getEvents());
            oos.writeObject(this.getPlayerNames());
            oos.writeObject(this.getPlayerScores());
            oos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new TronException("Unable to save log to file.");
        }
    }

    @Override
    public void load() throws TronException {
        super.load();
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(this._fileName));
            this.setEvents((List)ois.readObject());
            this.setPlayerNames((String[])ois.readObject());
            this.setPlayerScores((List)ois.readObject());
            ois.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new TronException("Unable to read log from file.");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new TronException("Unable to read log from file.");
        }
    }
}

