/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.score;

import jp.ac.nii.icpc2010.Tron;
import jp.ac.nii.icpc2010.playfield.PlayField;
import jp.ac.nii.icpc2010.score.AbstractScore;

public class SimpleScore
extends AbstractScore {
    private int coins;
    private int trail;

    @Override
    public String toString() {
        return String.format("%3d,%4d", this.coins, this.trail);
    }

    @Override
    public double getValue() {
        return 10 * this.coins + this.trail;
    }

    @Override
    public void add(AbstractScore score) {
        this.coins += ((SimpleScore)score).coins;
        this.trail += ((SimpleScore)score).trail;
    }

    public static AbstractScore[] getScores(PlayField playField) {
        AbstractScore[] scores = new SimpleScore[playField.getNumOfPlayers()];
        int i = 0;
        while (i < playField.getNumOfPlayers()) {
            Tron tron = playField.getTron(i);
            scores[i] = new SimpleScore();
            ((SimpleScore)scores[i]).coins = tron.getCoins();
            int x = 0;
            while (x < playField.getWidth()) {
                int y = 0;
                while (y < playField.getHeight()) {
                    if (playField.getObjectAt(x, y) == PlayField.playerTrail(i)) {
                        ++((SimpleScore)scores[i]).trail;
                    }
                    ++y;
                }
                ++x;
            }
            ++i;
        }
        return scores;
    }

    @Override
    public int compareTo(AbstractScore score) {
        double b;
        double a = this.getValue();
        if (a > (b = score.getValue())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }
}

