/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.submission;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;

public class SubmissionUtils {
    static Writer output = null;
    private static SubmissionUtils instance;
    SimpleDateFormat sdf = new SimpleDateFormat(this.DATE_FORMAT_NOW);
    String DATE_FORMAT_NOW = "HH:mm:ss";

    private SubmissionUtils() {
        try {
            output = new BufferedWriter(new FileWriter("debug.log"));
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    public static void closeLog() {
        try {
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static SubmissionUtils Instance() {
        if (instance == null) {
            instance = new SubmissionUtils();
        }
        return instance;
    }

    public static void error(String msg, Object obj) {
        SubmissionUtils.Instance()._error(msg, obj);
    }

    public static void debug(String msg, Object obj) {
        SubmissionUtils.Instance()._debug(msg, obj);
    }

    private void _error(String msg, Object obj) {
        System.err.println("[ERROR] <" + (obj == null ? "static" : obj.getClass().getSimpleName()) + "> " + msg);
    }

    private void _debug(String msg, Object obj) {
        try {
            System.out.println("[DEBUG] <" + (obj == null ? "static" : obj.getClass().getSimpleName()) + "> " + msg);
            output.write("[DEBUG] <" + (obj == null ? "static" : obj.getClass().getSimpleName()) + "> " + msg + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copy(String fromFileName, String toFileName) throws IOException {
        File dir;
        String parent;
        File fromFile = new File(fromFileName);
        File toFile = new File(toFileName);
        if (!fromFile.exists()) {
            throw new IOException("FileCopy: no such source file: " + fromFileName);
        }
        if (!fromFile.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + fromFileName);
        }
        if (!fromFile.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + fromFileName);
        }
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        if (toFile.exists()) {
            toFile.delete();
        }
        if ((parent = toFile.getParent()) == null) {
            parent = System.getProperty("user.dir");
        }
        if (!(dir = new File(parent)).exists()) {
            throw new IOException("FileCopy: destination directory doesn't exist: " + parent);
        }
        if (dir.isFile()) {
            throw new IOException("FileCopy: destination is not a directory: " + parent);
        }
        if (!dir.canWrite()) {
            throw new IOException("FileCopy: destination directory is unwriteable: " + parent);
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException iOException) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

