/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.tournament;

import java.io.File;
import java.util.List;
import jp.ac.nii.icpc2010.TronException;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.recorder.FileRecorder;
import jp.ac.nii.icpc2010.tournament.Player;

public class Match {
    private Player playerOne;
    private Player playerTwo;
    private double result;
    private File recording;

    public Match(Player one, Player two, File recording, OptionsManager om) {
        this.playerOne = one;
        this.playerTwo = two;
        this.recording = recording;
        FileRecorder fr = new FileRecorder(new String[]{one.toString(), two.toString()}, recording.getAbsolutePath(), om);
        try {
            fr.load();
        }
        catch (TronException e) {
            e.printStackTrace();
            System.exit(1);
        }
        List<Double> scores = fr.getPlayerScores();
        this.result = scores.get(0) - scores.get(1);
    }

    public Player getPlayerOne() {
        return this.playerOne;
    }

    public Player getPlayerTwo() {
        return this.playerTwo;
    }

    public double getResult(Player p) {
        return p == this.playerOne ? this.result : -this.result;
    }

    public File getRecording() {
        return this.recording;
    }
}

