/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.tournament;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import jp.ac.nii.icpc2010.tournament.Group;
import jp.ac.nii.icpc2010.tournament.Logger;
import jp.ac.nii.icpc2010.tournament.Player;
import jp.ac.nii.icpc2010.tournament.QueuedMatch;
import jp.ac.nii.icpc2010.tournament.Round;
import jp.ac.nii.icpc2010.tournament.Tournament;
import jp.ac.nii.icpc2010.tournament.TournamentSlave;

public class TournamentMaster
extends Thread {
    private Tournament tournament;
    Round currentRound;
    private Queue<QueuedMatch> queuedMatches = new ConcurrentLinkedQueue<QueuedMatch>();
    private int runningMatches;

    public TournamentMaster(List<Player> players, int slaves) {
        Logger.log("TOURNAMENT for " + players.size() + " teams");
        this.tournament = new Tournament();
        this.currentRound = new Round(0);
        this.tournament.addRound(this.currentRound);
        Group g0 = new Group();
        int p = 0;
        while (p < players.size()) {
            g0.addPlayer(players.get(p));
            ++p;
        }
        this.currentRound.addGroup(g0);
        this.queueRound();
        this.start();
        int x = 0;
        while (x++ < slaves) {
            new TournamentSlave(this);
        }
    }

    public QueuedMatch pollQueuedMatch() {
        return this.queuedMatches.poll();
    }

    public synchronized void reportFinishedMatch() {
        --this.runningMatches;
    }

    @Override
    public void run() {
        while (true) {
            if (this.runningMatches != 0) {
                try {
                    TournamentMaster.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            for (Group g : this.currentRound.getGroups()) {
                g.computeTotalScores();
                g.flagComputed();
            }
            if (this.currentRound.getGroups().size() <= 1) break;
            this.queueRound();
        }
        List<Player> finalProceedingPlayers = this.currentRound.collectProceedingPlayers();
        Collections.sort(finalProceedingPlayers);
        this.tournament.setWinner(finalProceedingPlayers.get(finalProceedingPlayers.size() - 1));
        Logger.log("WINNER = " + this.tournament.getWinner());
    }

    private void queueRound() {
        this.runningMatches = 0;
        List<Player> proceedingPlayers = this.currentRound.collectProceedingPlayers();
        Logger.log("# of proceeding players = " + proceedingPlayers.size());
        List<Group> currentGroups = TournamentMaster.splitIntoGroups(proceedingPlayers);
        this.currentRound = new Round(this.currentRound.getNumber() + 1);
        this.tournament.addRound(this.currentRound);
        for (Group g : currentGroups) {
            this.currentRound.addGroup(g);
        }
        Logger.log("LEVEL " + this.currentRound.getNumber() + " (" + currentGroups.size() + " groups)");
        int x = 0;
        for (Group g : this.currentRound.getGroups()) {
            Logger.log("GROUP " + ++x + " = " + g);
            this.queueGroup(g, this.currentRound);
        }
    }

    private void queueGroup(Group group, Round round) {
        List<Player> players = group.getPlayers();
        int p = 0;
        while (p < players.size()) {
            int q = p + 1;
            while (q < players.size()) {
                Player one = players.get(p);
                Player two = players.get(q);
                this.queuedMatches.add(new QueuedMatch(one, two, round, group));
                ++this.runningMatches;
                ++q;
            }
            ++p;
        }
    }

    private static List<Group> splitIntoGroups(List<Player> players) {
        ArrayList<Group> groups = new ArrayList<Group>();
        int groupCount = (int)Math.ceil((double)players.size() / 4.0);
        int x = 0;
        while (x < groupCount) {
            groups.add(new Group());
            ++x;
        }
        int curGroup = 0;
        int p = 0;
        while (p < players.size()) {
            ((Group)groups.get(curGroup)).addPlayer(players.get(p));
            curGroup = (curGroup + 1) % groupCount;
            ++p;
        }
        return groups;
    }
}

