package jp.ac.nii.icpc2010.players;

import java.util.ArrayList;
import java.util.List;

import jp.ac.nii.icpc2010.players.BasePlayer;
import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.IPlayField;

/**
 * Simply choose the destination farthest from the opponent
 * 
 * based on "Robert Xiao's Tron Strategy Guide"
 * (see http://csclub.uwaterloo.ca/contest/xiao_strategy.php)
 * 
 * @author yukino
 *
 */
public class EnemyAvoidancePlayer extends BasePlayer
{

	public EnemyAvoidancePlayer(int id, IPlayField playField) {
		super(id, playField);
		// TODO Auto-generated constructor stub
	}

	FieldDirection prev_dir;

	List<FieldDirection> order = getRandomDirs();

	public FieldDirection getInput()
    {
		int curx = getX();
		int cury = getY();
		
		List<FieldDirection> safeDirs = getSafeDirs(curx, cury);
		
		if (safeDirs.isEmpty())
		{
			//give up
			return prev_dir;
		}
		
		FieldDirection decision = safeDirs.get(0);
		double bestdist = 0;
      
		// see only one enemy
		int enemyId = getEnemyIds().get(0);
		int[] enemyPos = getPositionById(enemyId);
    	  
		for (FieldDirection dir: safeDirs)
		{
			int[] pred = getPlayField().stepOne(curx, cury, dir);
			double dist = Math.pow(pred[0] - enemyPos[0], 2) + Math.pow(pred[1] - enemyPos[1], 2);
			if(dist > bestdist)
			{
				bestdist = dist;
				decision = dir;
			}
		}
      
      prev_dir = decision;
      return decision;
    }
}