 package jp.ac.nii.icpc2010;

import java.awt.event.*;
import java.io.IOException;

import jp.ac.nii.icpc2010.manager.DisplayManager;
import jp.ac.nii.icpc2010.manager.GameManager;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.playfield.PlayField;


public class Main implements KeyListener
{
	private final PlayField	_field;
	private DisplayManager _dmanager;
	private OptionsManager om;

	public static void main(String[] args)
	{
		//First force initialization of options
		OptionsManager om = new OptionsManager(args);
		
		Main main = new Main(om);

		// show display
		if (!om.isTournamentMode()) {
			DisplayManager dmanager = main._dmanager = new DisplayManager("Tron", main._field, om);
			dmanager.addWindowListener(new WindowAdapter(){
				public void windowClosing(WindowEvent e){
					System.exit(0);
				}
			});
			dmanager.addKeyListener(main);
			Thread thDisplay = new Thread(dmanager);
			thDisplay.start();
		}

		// opening
		try {
			Thread.sleep(om.getOpeningTime());
		} catch (InterruptedException e) {
			e.printStackTrace();
			System.exit(1);
		}

		//System.exit(1);

		GameManager gmanager = null;

		// play game
		try {
			gmanager = new GameManager(main._field, om);
		} catch (TronException te) {
			te.printStackTrace();
			System.exit(1);
		}

		Thread thGame = new Thread(gmanager);
		thGame.start();

		while(thGame.isAlive()){
			try {
				thGame.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
				System.exit(1);
			}
		}

		//
		if (!om.isTournamentMode())
			System.out.println("game ends");
	}
	
	private Main(OptionsManager om)
	{
		this.om = om;
		_field = new PlayField(om);
		try {
			_field.init(om.getOpeningName());
		} catch (TronException e) {
			e.printStackTrace();
			System.exit(1);
		} catch(IOException e){
			e.printStackTrace();
			System.exit(1);
		}
	}


	@Override
	public void keyPressed(KeyEvent e) {
	    long timeslot, oldTimeslot;
	    switch(e.getKeyCode())
		{
        case KeyEvent.VK_1:
            timeslot = om.getTurnTimeslot() + 50;
            om.setTurnTimeslot(timeslot);
            System.out.println("Timeslot " + timeslot + ".");
            break;
        case KeyEvent.VK_2:
            oldTimeslot = om.getTurnTimeslot();
            timeslot = Math.max(oldTimeslot - 50, 0);
            om.setTurnTimeslot(timeslot);
            if(timeslot != oldTimeslot){
                System.out.println("Timeslot " + timeslot + ".");                
            }
            break;
        case KeyEvent.VK_A:
            if(_dmanager != null){
                _dmanager.incrementCellWidth();
            }
            break;
		case KeyEvent.VK_S:
			if(_dmanager != null){
				_dmanager.incrementCellHeight();
			}
			break;
		case KeyEvent.VK_D:
			if(_dmanager != null){
				_dmanager.decrementCellWidth();
			}
			break;
		case KeyEvent.VK_F:
			if(_dmanager != null){
				_dmanager.decrementCellHeight();
			}
			break;
		default:
			_field.setKeyPressed(e);
		}
	}

	@Override
	public void keyReleased(KeyEvent e) {
	}

	@Override
	public void keyTyped(KeyEvent e) {
	}
}
