package jp.ac.nii.icpc2010.players;
import java.util.ArrayList;
import java.util.List;

import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.IPlayField;

/**
 * Attempts to move onto a square adjacent to a wall, 
 * thus "hugging" the wall by following it around
 * 
 * based on "Robert Xiao's Tron Strategy Guide"
 * (see http://csclub.uwaterloo.ca/contest/xiao_strategy.php)
 * 
 * @author yukino
 *
 */
public class WallHuggingPlayer extends BasePlayer
{
	public WallHuggingPlayer(int id, IPlayField playField) {
		super(id, playField);
		// TODO Auto-generated constructor stub
	}

	FieldDirection prev_dir;

	public FieldDirection getInput()
    {
		int curx = getX();
		int cury = getY();
		
		List<FieldDirection> safeDirs = getSafeDirs(curx, cury);
		
		if (safeDirs.isEmpty())
		{
			//give up
			return prev_dir;
		}

		FieldDirection decision = safeDirs.get(0);
	      
		for (FieldDirection dir: safeDirs)
		{
			int[] pred = getPlayField().stepOne(curx, cury, dir);

			for (int[] adj: getAdjacentPos(pred[0], pred[1]))
			{
				if (isWall(adj[0], adj[1]))
				{
					decision = dir;
					break;
				}
			}
		}
    	  
		prev_dir = decision;
		return decision;
    }
}