package jp.ac.nii.icpc2010.recorder;

import java.util.List;

import jp.ac.nii.icpc2010.TronException;

public interface IRecorder {

	/**
	 * record final score. They must be ordered consistently, so that the event from player i is always at position i
	in the array. 
	 */	
	public void addPlayerScore(double score) throws TronException;
	/**
	 * record events for one turn. They must be ordered consistently, so that the event from player i is always at position i
	in the array. 
	 */	
	public void addEvents(PlayerEvent[] events) throws TronException;
	
	/**
	 * Finalize the log. If recording, this must be called when there is no more input. 
	 */
	public void closeWriting() throws TronException;
	
	/**
	 * When playing rather than recording, call this method first to prepare playback.
	 * After this method has been called, nextEvents may be called safely.
	 * @throws TronException
	 */
	public void load() throws TronException;
	
	
	public List<PlayerEvent[]> getEvents();
	
	/**
	 * Get the names of players.
	 * @return
	 */
	public String[] getPlayerNames();

	/**
	 * Get the scores of the players.
	 * @return
	 */
	public List<Double> getPlayerScores();
}