/*
 * Decompiled with CFR 0.152.
 */
package Collusion;

import Animations.FireWorks;
import Animations.FlagWin;
import Objects.Player;
import SandBox.Mario;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.collision.BasicCollisionGroup;
import com.golden.gamedev.object.sprite.VolatileSingleImage;
import com.golden.gamedev.util.ImageUtil;
import java.util.Random;

public class Player_CheckPoint
extends BasicCollisionGroup {
    Mario game;

    public Player_CheckPoint(Mario f) {
        this.game = f;
    }

    public void collided(Sprite player, Sprite checkpoint) {
        Player p = (Player)player;
        switch (checkpoint.getID()) {
            case 23: {
                Random r = new Random();
                if (r.nextBoolean()) {
                    this.game.AnimationGroup.add(new FireWorks((int)checkpoint.getX(), (int)checkpoint.getY(), this.game));
                }
                this.game.LevelComplete(checkpoint);
                p.setActive(false);
                this.game.UnderGroup.add(new FlagWin(checkpoint.getX(), this.game));
                this.game.DelayToNextCheckPoint = 400;
                this.game.parent.amitsAudioPlayer.stopAllMusic();
                this.game.parent.amitsAudioPlayer.smb_stage_clear.play();
                break;
            }
            case 16: {
                this.game.boss.BadGameGlitch();
                this.game.VolitileGroup.add(new Sprite(this.game.bsLoader.getStoredImage("AnotherCastleMessage"), checkpoint.getX() - 224.0, checkpoint.getY() - 192.0));
                VolatileSingleImage black = new VolatileSingleImage(ImageUtil.createImage(384, 96), checkpoint.getX() - 224.0, checkpoint.getY() - 164.0, 50);
                this.game.VolitileGroup.add(black);
                p.setX(checkpoint.getX() - (double)p.getWidth());
                p.StopSpeed();
                p.NoControlling();
                p.StopMoveForward();
                this.game.LevelComplete(checkpoint, 400);
                break;
            }
            case 24: {
                if (!p.KeyPressRight() || !p.OnGround) break;
                this.game.MarioGoingInsidePumpToRight();
                this.game.LevelComplete(checkpoint);
                this.game.player.setActive(false);
                this.game.parent.amitsAudioPlayer.stopAllMusic();
                this.game.parent.amitsAudioPlayer.smb_pipe.play();
                p.setActive(false);
                break;
            }
            case 25: {
                if (!(p.getX() < checkpoint.getX() + 10.0) || !(p.getX() > checkpoint.getX() - 10.0) || !p.KeyPressedDown()) break;
                this.game.MarioGoingDownAnimation();
                this.game.LevelComplete(checkpoint);
                this.game.parent.amitsAudioPlayer.stopAllMusic();
                this.game.parent.amitsAudioPlayer.smb_pipe.play();
                p.setActive(false);
                break;
            }
            case 26: {
                this.game.boss.BadGameGlitch();
                this.game.VolitileGroup.add(new Sprite(this.game.bsLoader.getStoredImage("QuestComplete"), checkpoint.getX() - 224.0, checkpoint.getY() - 192.0));
                p.setX(checkpoint.getX() - (double)p.getWidth());
                p.StopSpeed();
                p.NoControlling();
                p.StopMoveForward();
                break;
            }
            case 27: {
                this.game.LevelComplete(checkpoint);
                p.setActive(false);
                this.game.DelayToNextCheckPoint = 200;
                this.game.parent.amitsAudioPlayer.stopAllMusic();
                break;
            }
            case 28: {
                if (!p.KeyPressedUP) break;
                this.game.LevelComplete(checkpoint);
                p.setActive(false);
                this.game.DelayToNextCheckPoint = 200;
                this.game.parent.amitsAudioPlayer.stopAllMusic();
            }
        }
    }
}

