/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine;

import com.golden.gamedev.engine.BaseIO;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BaseLoader {
    private BaseIO base;
    private Color maskColor;
    private Map imageBank;
    private Map imagesBank;

    public BaseLoader(BaseIO base, Color maskColor) {
        this.base = base;
        this.maskColor = maskColor;
        this.imageBank = new HashMap(5);
        this.imagesBank = new HashMap(30);
    }

    public BufferedImage getImage(String imagefile, boolean useMask) {
        BufferedImage image = (BufferedImage)this.imageBank.get(imagefile);
        if (image == null) {
            URL url = this.base.getURL(imagefile);
            image = useMask ? ImageUtil.getImage(url, this.maskColor) : ImageUtil.getImage(url);
            this.imageBank.put(imagefile, image);
        }
        return image;
    }

    public BufferedImage getImage(String imagefile) {
        return this.getImage(imagefile, true);
    }

    public BufferedImage[] getImages(String imagefile, int col, int row, boolean useMask) {
        BufferedImage[] image = (BufferedImage[])this.imagesBank.get(imagefile);
        if (image == null) {
            URL url = this.base.getURL(imagefile);
            image = useMask ? ImageUtil.getImages(url, col, row, this.maskColor) : ImageUtil.getImages(url, col, row);
            this.imagesBank.put(imagefile, image);
        }
        return image;
    }

    public BufferedImage[] getImages(String imagefile, int col, int row) {
        return this.getImages(imagefile, col, row, true);
    }

    public boolean removeImage(BufferedImage image) {
        Iterator it = this.imageBank.values().iterator();
        while (it.hasNext()) {
            if (it.next() != image) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public boolean removeImages(BufferedImage[] images) {
        Iterator it = this.imagesBank.values().iterator();
        while (it.hasNext()) {
            if (it.next() != images) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public BufferedImage removeImage(String imagefile) {
        return (BufferedImage)this.imageBank.remove(imagefile);
    }

    public BufferedImage[] removeImages(String imagefile) {
        return (BufferedImage[])this.imagesBank.remove(imagefile);
    }

    public void clearCache() {
        this.imageBank.clear();
        this.imagesBank.clear();
    }

    public void storeImage(String key, BufferedImage image) {
        if (this.imageBank.get(key) != null) {
            throw new ArrayStoreException("Key -> " + key + " is bounded to " + this.imageBank.get(key));
        }
        this.imageBank.put(key, image);
    }

    public void storeImages(String key, BufferedImage[] images) {
        if (this.imagesBank.get(key) != null) {
            throw new ArrayStoreException("Key -> " + key + " is bounded to " + this.imagesBank.get(key));
        }
        this.imagesBank.put(key, images);
    }

    public BufferedImage getStoredImage(String key) {
        return (BufferedImage)this.imageBank.get(key);
    }

    public BufferedImage[] getStoredImages(String key) {
        return (BufferedImage[])this.imagesBank.get(key);
    }

    public BaseIO getBaseIO() {
        return this.base;
    }

    public void setBaseIO(BaseIO base) {
        this.base = base;
    }

    public Color getMaskColor() {
        return this.maskColor;
    }

    public void setMaskColor(Color c) {
        this.maskColor = c;
    }

    public String toString() {
        StringBuffer imageKey = new StringBuffer();
        StringBuffer imagesKey = new StringBuffer();
        Iterator imageIt = this.imageBank.keySet().iterator();
        Iterator imagesIt = this.imagesBank.keySet().iterator();
        imageKey.append("\"");
        while (imageIt.hasNext()) {
            imageKey.append(imageIt.next());
            if (!imageIt.hasNext()) continue;
            imageKey.append(",");
        }
        imageKey.append("\"");
        imagesKey.append("\"");
        while (imagesIt.hasNext()) {
            String key = (String)imagesIt.next();
            BufferedImage[] image = (BufferedImage[])this.imagesBank.get(key);
            int len = image == null ? -1 : image.length;
            imagesKey.append(key).append("(").append(len).append(")");
            if (!imagesIt.hasNext()) continue;
            imagesKey.append(",");
        }
        imagesKey.append("\"");
        return super.toString() + " " + "[maskColor=" + this.maskColor + ", BaseIO=" + this.base + ", imageLoaded=" + imageKey + ", imagesLoaded=" + imagesKey + "]";
    }
}

