/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.funbox;

import com.golden.gamedev.engine.graphics.WindowExitListener;
import com.golden.gamedev.util.ImageUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public abstract class GameSettings
extends JDialog
implements ActionListener,
Runnable {
    protected JCheckBox Skip;
    public JTextField Game_Width;
    public JTextField Game_Height;
    protected JCheckBox fullscreen;
    protected JCheckBox bufferstrategy;
    protected JCheckBox sound;
    protected JButton btnOK;
    protected JButton btnCancel;
    protected URL splashImage;

    public GameSettings(URL splashImage) throws FileNotFoundException, IOException {
        super((Frame)null, "Settings", true);
        this.setResizable(false);
        this.addWindowListener(WindowExitListener.getInstance());
        this.setDefaultCloseOperation(2);
        this.splashImage = splashImage;
        JPanel contentPane = this.initGUI();
        this.setContentPane(contentPane);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public GameSettings() throws FileNotFoundException, IOException {
        this((URL)null);
    }

    public GameSettings(boolean fullscreen, boolean bufferStrategy, boolean sound) throws FileNotFoundException, IOException {
        this.initGUI();
        this.fullscreen.setSelected(fullscreen);
        this.bufferstrategy.setSelected(bufferStrategy);
        this.sound.setSelected(sound);
        this.dispose();
        this.start();
    }

    public GameSettings(boolean fullscreen) throws FileNotFoundException, IOException {
    }

    protected JPanel initGUI() throws FileNotFoundException, IOException {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        JLabel splashLabel = null;
        if (this.splashImage != null) {
            try {
                splashLabel = new JLabel(new ImageIcon(ImageUtil.getImage(this.splashImage)));
            }
            catch (Exception e) {
                splashLabel = null;
            }
        }
        JPanel optionPane = this.initSettings();
        JPanel submitPane = new JPanel();
        submitPane.setLayout(new FlowLayout(2));
        submitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(this);
        this.getRootPane().setDefaultButton(this.btnOK);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        submitPane.add(this.btnOK);
        submitPane.add(this.btnCancel);
        if (splashLabel != null) {
            contentPane.add((Component)splashLabel, "North");
        }
        if (optionPane != null) {
            contentPane.add((Component)optionPane, "Center");
        }
        contentPane.add((Component)submitPane, "South");
        return contentPane;
    }

    protected JPanel initSettings() throws FileNotFoundException, IOException {
        boolean fullscreenData = true;
        boolean bufferStrategyData = true;
        boolean soundData = true;
        boolean SkipData = false;
        this.Game_Width = new JTextField();
        this.Game_Height = new JTextField();
        this.Game_Width.setText("640");
        this.Game_Height.setText("480");
        File SETTINGS = new File("Setting.txt");
        if (SETTINGS.exists()) {
            FileInputStream fin = new FileInputStream(SETTINGS);
            DataInputStream in = new DataInputStream(fin);
            try {
                fullscreenData = in.readBoolean();
                bufferStrategyData = in.readBoolean();
                soundData = in.readBoolean();
                SkipData = in.readBoolean();
                this.Game_Width.setText(in.readInt() + "");
                this.Game_Height.setText(in.readInt() + "");
                if (Integer.parseInt(this.Game_Width.getText()) == 0 || "".equals(this.Game_Width.getText())) {
                    this.Game_Width.setText("640");
                    SETTINGS.delete();
                }
                if (Integer.parseInt(this.Game_Height.getText()) == 0 || "".equals(this.Game_Height.getText())) {
                    this.Game_Height.setText("480");
                    SETTINGS.delete();
                }
                in.close();
            }
            catch (EOFException e) {
                SETTINGS.delete();
                fullscreenData = false;
                bufferStrategyData = false;
                soundData = false;
                SkipData = false;
                this.Game_Width.setText("640");
                this.Game_Height.setText("480");
            }
            catch (NumberFormatException e) {
                SETTINGS.delete();
                this.Game_Width.setText("640");
                this.Game_Height.setText("480");
            }
        }
        JPanel optionPane = new JPanel();
        optionPane.setLayout(new GridLayout(0, 2));
        Border border = BorderFactory.createEmptyBorder(6, 4, 3, 4);
        optionPane.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createTitledBorder("Game Settings")));
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        boolean supportFSEM = true;
        try {
            supportFSEM = device.isFullScreenSupported();
        }
        catch (Throwable e) {
            e.printStackTrace();
            supportFSEM = false;
        }
        this.Skip = new JCheckBox("Skip This Next Time.", SkipData);
        this.Game_Width.setToolTipText("Game Width");
        this.Game_Height.setToolTipText("Game Height");
        this.fullscreen = new JCheckBox("Fullscreen", fullscreenData);
        this.fullscreen.setEnabled(supportFSEM);
        this.fullscreen.setToolTipText(supportFSEM ? "fullscreen/windowed mode" : "fullscreen mode not supported");
        this.bufferstrategy = new JCheckBox("Bufferstrategy", bufferStrategyData);
        this.bufferstrategy.setToolTipText("turn this off if the game experiencing graphics problem");
        this.sound = new JCheckBox("Sound", soundData);
        this.sound.setToolTipText("turn on/off sound and music");
        optionPane.add(this.fullscreen);
        optionPane.add(this.bufferstrategy);
        optionPane.add(this.sound);
        optionPane.add(this.Skip);
        optionPane.add(this.Game_Width);
        optionPane.add(this.Game_Height);
        return optionPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOK) {
            FileOutputStream fout = null;
            try {
                File SETTINGS = new File("Setting.txt");
                fout = new FileOutputStream(SETTINGS);
                DataOutputStream out = new DataOutputStream(fout);
                out.writeBoolean(this.fullscreen.isSelected());
                out.writeBoolean(this.bufferstrategy.isSelected());
                out.writeBoolean(this.sound.isSelected());
                out.writeBoolean(this.Skip.isSelected());
                out.writeInt(Integer.parseInt(this.Game_Width.getText()));
                out.writeInt(Integer.parseInt(this.Game_Height.getText()));
                out.close();
                this.dispose();
                new Thread(this).start();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    fout.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        } else if (e.getSource() == this.btnCancel) {
            System.exit(0);
        }
    }

    public void run() {
        this.start();
    }

    public abstract void start();
}

