/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.collision;

import com.golden.gamedev.object.CollisionManager;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.SpriteGroup;
import com.golden.gamedev.object.collision.CollisionRect;
import com.golden.gamedev.object.collision.CollisionShape;

public abstract class BasicCollisionGroup
extends CollisionManager {
    protected final CollisionRect rect1 = new CollisionRect();
    protected final CollisionRect rect2 = new CollisionRect();
    public boolean pixelPerfectCollision;

    public CollisionShape getCollisionShape1(Sprite s1) {
        this.rect1.setBounds(s1.getX(), s1.getY(), s1.getWidth(), s1.getHeight());
        return this.rect1;
    }

    public CollisionShape getCollisionShape2(Sprite s2) {
        this.rect2.setBounds(s2.getX(), s2.getY(), s2.getWidth(), s2.getHeight());
        return this.rect2;
    }

    public void checkCollision() {
        SpriteGroup group1 = this.getGroup1();
        SpriteGroup group2 = this.getGroup2();
        if (!group1.isActive() || !group2.isActive()) {
            return;
        }
        Sprite[] member1 = group1.getSprites();
        Sprite[] member2 = group2.getSprites();
        int size1 = group1.getSize();
        int size2 = group2.getSize();
        block0: for (int i = 0; i < size1; ++i) {
            CollisionShape shape1;
            Sprite sprite1 = member1[i];
            if (!sprite1.isActive() || (shape1 = this.getCollisionShape1(sprite1)) == null) continue;
            for (int j = 0; j < size2; ++j) {
                CollisionShape shape2;
                Sprite sprite2 = member2[j];
                if (!sprite2.isActive() || sprite1 == sprite2 || (shape2 = this.getCollisionShape2(sprite2)) == null || !this.isCollide(sprite1, sprite2, shape1, shape2)) continue;
                this.collided(sprite1, sprite2);
                if (!sprite1.isActive() || (shape1 = this.getCollisionShape1(sprite1)) == null) continue block0;
            }
        }
    }

    public boolean isCollide(Sprite s1, Sprite s2, CollisionShape shape1, CollisionShape shape2) {
        if (!this.pixelPerfectCollision) {
            return shape1.intersects(shape2);
        }
        if (shape1.intersects(shape2)) {
            return CollisionManager.isPixelCollide(s1.getX(), s1.getY(), s1.getImage(), s2.getX(), s2.getY(), s2.getImage());
        }
        return false;
    }

    public abstract void collided(Sprite var1, Sprite var2);
}

