/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.DirectFalling;
import Animations.FallingDeadSprites;
import Animations.Smoke;
import Objects.BasicEnemy;
import SandBox.Mario;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.object.sprite.AdvanceSprite;
import com.golden.gamedev.object.sprite.VolatileSprite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class Rocket
extends AdvanceSprite
implements BasicEnemy {
    Mario game;
    int XSpeed = -5;
    int delay = 10;
    int[] animLeft = new int[]{0, 1, 2, 1};
    int[] animRight = new int[]{3, 4, 5, 4};

    public Rocket(double x, double y, String direction, BufferedImage[] bufferedImage, Mario g) {
        this.setImages(bufferedImage);
        this.setLocation(x, y);
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setAnimationTimer(new Timer(150));
        if ("gotoleft".equals(direction)) {
            this.XSpeed = -5;
            this.setAnimationFrame(this.animLeft);
        } else {
            this.XSpeed = 5;
            this.setAnimationFrame(this.animRight);
        }
        this.setID(109);
        this.game = g;
        this.game.AnimationGroup.add(new Smoke(this.getX(), this.getY(), this.game.bsLoader.getStoredImages("Smoke")));
    }

    public void update(long l) {
        if (this.delay > -1) {
            --this.delay;
        }
        if (this.delay < 0) {
            this.moveX(this.XSpeed);
            this.RemoveIfTooAway();
            super.update(l);
        }
    }

    public void render(Graphics2D g) {
        if (this.delay < 0) {
            super.render(g);
        }
    }

    public void CollidedWithBrick_GoToLeft() {
    }

    public void CollidedWithBrick_GoToRight() {
    }

    public int getType() {
        return this.getID();
    }

    public void MarioJumpedOnEnemy() {
        this.game.player.Jump(-8);
        this.game.AnimationGroup.add(new DirectFalling(this.getImage(), this.getX(), this.getY()));
        this.setActive(false);
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        }
    }

    public void KilledByFireBall() {
    }

    private void RemoveIfTooAway() {
        if (this.getScreenX() < -32.0) {
            this.setActive(false);
        }
        if (this.getScreenX() > 640.0) {
            this.setActive(false);
        }
    }

    public void bounce() {
    }

    public void setYloc(double d1) {
    }

    public void CollidedWithShell() {
    }

    public void CollidedWithMovingShell() {
        this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.getImage(), false));
        this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        this.setActive(false);
    }

    public void OtherEnemyTouchedFromRight() {
    }

    public void OtherEnemyTouchedFromLeft() {
    }

    public void CollidedWithMarioFromTOLeft() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.getImage(), false));
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void CollidedWithMarioTORight() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.getImage(), false));
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void EnemyJumperOnMario() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.getImage(), false));
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public int Life() {
        return 0;
    }

    public void CollidedWithJumping_Brick() {
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }
}

